<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Blog extends MY_Controller
{
    public function index()
    {
        $this->load->model(['Blog_model', 'Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model']);

        $data['blogs'] = $this->Blog_model->get_all();
        $data['category'] = $this->Blog_model->get_all_category();

        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('blog', $data);
    }

    public function blog_details($slug)
    {
        $this->load->model(['Blog_model', 'Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model']);
        $slug = urldecode($slug);
        $data['blogs'] = $this->Blog_model->get_all();
        $data['category'] = $this->Blog_model->get_all_category();
        $data['details'] = $this->Blog_model->get_blog_by_title($slug);

        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('blog-details', $data);
    }

    public function category_blog($category)
    {
        $this->load->model(['Blog_model', 'Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model']);
        $category = urldecode($category);
        $data['blogs'] = $this->Blog_model->get_blogs_by_category($category);
        $data['category'] = $this->Blog_model->get_all_category();

        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('category-blogs', $data);
    }



}