<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Career extends MY_Controller
{
    public function index()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model', 'job_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $data['jobs'] = $this->job_model->get_all();
        $this->load->view('career', $data);
    }

    public function submit_application()
    {
        $job_id = $this->input->post('job_id');
        $name = $this->input->post('name');
        $email = $this->input->post('email');
        $phone = $this->input->post('phone');
        $info = $this->input->post('info');

        // Ensure upload directory exists
        if (!is_dir('./uploads/resumes')) {
            mkdir('./uploads/resumes', 0777, true);
        }

        if (!empty($_FILES['resume']['name'])) {
            $config['upload_path'] = './uploads/resumes/';
            $config['allowed_types'] = 'pdf|doc|docx';
            $config['max_size'] = 2048; // 2 MB

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('resume')) {
                $uploadData = $this->upload->data();
                $resume = 'uploads/resumes/' . $uploadData['file_name'];

                $data = [
                    'job_id' => $job_id,
                    'name' => $name,
                    'email' => $email,
                    'phone' => $phone,
                    'resume' => $resume,
                    'info' => $info,
                ];

                $this->load->model('job_model');
                $this->job_model->submit_application($data);

                echo json_encode([
                    'status' => 'success',
                    'message' => 'Application submitted successfully!'
                ]);
            } else {
                echo json_encode([
                    'status' => 'error',
                    'message' => strip_tags($this->upload->display_errors())
                ]);
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'message' => 'Please upload your resume.'
            ]);
        }
    }

}