<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Contact extends MY_Controller
{
    public function index()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('contact', $data);
    }


    public function save()
    {
        $this->load->library('form_validation');

        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('email', 'Email', 'required|valid_email');
        $this->form_validation->set_rules('phone', 'phone', 'required|trim');
        $this->form_validation->set_rules('message', 'Message', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'name' => form_error('name'),
                    'email' => form_error('email'),
                    'phone' => form_error('phone'),
                    'message' => form_error('message')
                ]
            ]);
            return;
        }

        $data = [
            'name' => $this->input->post('name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'message' => $this->input->post('message'),
            'date' => date('Y-m-d')
        ];

        $this->load->model('Contact_model');
        $this->Contact_model->contact($data);

        echo json_encode([
            'status' => 'success',
            'message' => 'Thank you! Your message has been submitted.'
        ]);
    }
}