<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Home extends MY_Controller
{
    public function index()
    {
        $this->load->model(['slider_model', 'testimonial_model', 'Blog_model', 'Product_model', 'Service_model', 'Campaign_model', 'Video_gallery_model', 'page_model', 'news_model', 'team_model', 'Counter_model', 'section_model']);
        $data['slider'] = $this->slider_model->get_all_slider();
        $data['testimonials'] = $this->testimonial_model->get_all();
        $data['blogs'] = $this->Blog_model->get_all();
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['services'] = $this->Service_model->get_all_service_category();
        $data['products'] = $this->Product_model->get_all_product_category();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['video'] = $this->Video_gallery_model->get_all();
        $data['page'] = $this->page_model->get_all();
        $data['news'] = $this->news_model->get_all();
        $data['team'] = $this->team_model->get_all_team();

        $data['counters'] = $this->section_model->is_active('counters');
        $data['directors'] = $this->section_model->is_active('board-of-directors');
        $data['management'] = $this->section_model->is_active('key-management');
        $data['testimonial'] = $this->section_model->is_active('testimonials');
        $data['blog'] = $this->section_model->is_active('blog');
        $data['newsandevent'] = $this->section_model->is_active('news-and-event');

        $this->Counter_model->increase_count();
        $data['total_visits'] = $this->Counter_model->get_count();



        $this->load->view('index', $data);
    }


    public function fetch_counter_data()
    {
        $query = $this->db->get('counter'); // 👈 apni table ka naam daalna
        $data = $query->row_array();

        echo json_encode([
            'total_district' => $data['total_district'],
            'total_village' => $data['total_village'],
            'team_member' => $data['team_member'],
            'females_members' => $data['females_members'],
            'milk_qty' => $data['milk_qty']
        ]);
    }

    public function terms_and_conditions()
    {
        $this->load->model(['Product_model', 'Service_model', 'page_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('terms-and-conditions', $data);
    }
    public function privacy_policy()
    {
        $this->load->model(['Product_model', 'Service_model', 'page_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('privacy-policy', $data);
    }
}