<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Annual_reports extends CI_Controller
{
    public function index()
    {
        $this->load->model('report_model');
        $data['reports'] = $this->report_model->get_all();
        $this->load->view('admin/annual-reports', $data);
    }

    public function add_annual_report()
    {
        $this->load->view('admin/add-annual-report');
    }

    public function submit_report()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('hindi_subject', 'Hindi Subject', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'subject' => form_error('subject'),
                'hindi_subject' => form_error('hindi_subject'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $reportData = [
            'subject' => $this->input->post('subject'),
            'hindi_subject' => $this->input->post('hindi_subject'),
        ];

        // Upload folder config
        $uploadPath = './uploads/reports/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'pdf';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_file']['name'])) {
            if ($this->upload->do_upload('featured_file')) {
                $uploadData = $this->upload->data();
                $reportData['featured_file'] = 'uploads/reports/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_file' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_file' => 'Please select an image']
            ]);
            return;
        }

        // Save blog
        $this->load->model('report_model');
        $report_id = $this->report_model->add_report($reportData);

        if ($report_id) {
            $this->session->set_flashdata('message', 'Annual Report added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('annual-reports-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Annual Report, try again.']
            ]);
        }
    }

    public function edit_annual_report($id)
    {
        $this->load->model('report_model');
        $data['report'] = $this->report_model->get_report_by_id($id);
        $this->load->view('admin/edit-annual-report', $data);
    }


    public function update_report()
    {
        // Always return JSON
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('hindi_subject', 'Hindi Subject', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'subject' => form_error('subject'),
                'hindi_subject' => form_error('hindi_subject'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }



        // Get ID
        $id = $this->input->post('id');
        if (empty($id)) {
            echo json_encode(['status' => 'error', 'errors' => ['general' => 'Invalid request.']]);
            return;
        }

        // Prepare updated data
        $reportData = [
            'subject' => $this->input->post('subject'),
            'hindi_subject' => $this->input->post('hindi_subject'),
        ];

        // Upload config (allow images + pdf)
        $uploadPath = './uploads/reports/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg|pdf',
            'max_size' => 5120, // 5MB in KB (CI expects KB)
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload');
        $this->upload->initialize($config);

        // Load model
        $this->load->model('report_model');

        // Get old record (to delete file if replaced)
        $oldTender = $this->report_model->get_report_by_id($id);
        $oldImage = $oldTender ? $oldTender->featured_file : '';

        // If a new file is present in $_FILES and has a name => process upload
        if (!empty($_FILES) && isset($_FILES['featured_file']) && !empty($_FILES['featured_file']['name'])) {
            if ($this->upload->do_upload('featured_file')) {
                $uploadData = $this->upload->data();
                // Save relative path
                $reportData['featured_file'] = 'uploads/reports/' . $uploadData['file_name'];

                // Delete old file if exists and not empty
                if (!empty($oldImage) && file_exists(FCPATH . $oldImage)) {
                    @unlink(FCPATH . $oldImage);
                }
            } else {
                // Upload failed
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_file' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }
        // else: no new file uploaded -> keep existing featured_file untouched

        // Update record
        $updated = $this->report_model->update_report($id, $reportData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Annual Report updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('annual-reports-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Annual Report, please try again.']
            ]);
        }
    }
    public function delete_report($id)
    {
        $this->load->model('report_model');
        $this->report_model->delete_report($id);
        $this->session->set_flashdata('message', 'Annual Report delete successfully');
        redirect(base_url('annual-reports-list'));

    }


}