<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Award_and_recognition extends CI_Controller
{
    public function index()
    {
        $this->load->model('Award_model');
        $data['award'] = $this->Award_model->get_all();
        $this->load->view('admin/award', $data);
    }

    public function add_award_and_recognition()
    {
        $this->load->view('admin/add-award');
    }


    public function submit_award()
    {
        $this->form_validation->set_error_delimiters('', '');

        // === Validation rules ===
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');


        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),

            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data ===
        $awardData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),

        ];

        // === File Upload Config ===
        $uploadPath = './uploads/awards/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120, // 5MB
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Handle Image Uploads ===
        $imageFields = [
            'featured_image_one',
            'featured_image_two',
        ];

        foreach ($imageFields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $uploadData = $this->upload->data();
                    $awardData[$field] = 'uploads/awards/' . $uploadData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => [$field => 'Please select an image for ' . str_replace('_', ' ', $field)]
                ]);
                return;
            }
        }

        // === Save service ===
        $this->load->model('Award_model');
        $service_id = $this->Award_model->add_award($awardData);

        if ($service_id) {
            $this->session->set_flashdata('message', 'Award & Recognition added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('award-and-recognition-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Award & Recognition, please try again.']
            ]);
        }
    }


    public function edit_award_and_recognition($id)
    {
        $this->load->model('Award_model');
        $data['award'] = $this->Award_model->get_award_by_id($id);
        $this->load->view('admin/edit-award', $data);
    }

    public function update_award()
    {
        $this->form_validation->set_error_delimiters('', '');

        // === Validation Rules ===
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),

            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data ===
        $id = $this->input->post('id');
        $awardData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'updated_at' => date('Y-m-d H:i:s'),
        ];

        // === Upload Configuration ===
        $uploadPath = './uploads/awards/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120,
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Helper to Handle Uploads ===
        $image_fields = ['featured_image_one', 'featured_image_two'];

        // Fetch current record to delete old images
        $this->load->model('Award_model');
        $current = $this->Award_model->get_award_by_id($id);

        foreach ($image_fields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $uploadData = $this->upload->data();
                    $awardData[$field] = 'uploads/awards/' . $uploadData['file_name'];

                    // Delete old image if exists
                    if (!empty($current->$field) && file_exists(FCPATH . $current->$field)) {
                        unlink(FCPATH . $current->$field);
                    }
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        // === Update Database ===
        $updated = $this->Award_model->update_award($id, $awardData);

        if ($updated) {
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('award-and-recognition-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Award & Recognition. Please try again.']
            ]);
        }
    }
    public function delete_award($id)
    {
        $this->load->model('Award_model');
        $this->Award_model->delete_service_details($id);
        $this->session->set_flashdata('message', 'Award & Recognition delete successfully');
        redirect(base_url('award-and-recognition-list'));

    }
}