<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Campaign extends CI_Controller
{
    public function index()
    {
        $this->load->model('Campaign_model');
        $data['campaigns'] = $this->Campaign_model->get_all();
        $this->load->view('admin/campaigns', $data);
    }

    public function add_campaign()
    {
        $this->load->view('admin/add-campaign');
    }

    public function submit_campaign()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('description', 'Description', 'required|trim');
        $this->form_validation->set_rules('hindi_description', 'Hindi Description', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'description' => form_error('description'),
                'hindi_description' => form_error('hindi_description'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $campaignData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'description' => $this->input->post('description'),
            'hindi_description' => $this->input->post('hindi_description'),
        ];

        // Upload folder config
        $uploadPath = './uploads/campaigns/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // ✅ Image is optional now
        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $campaignData['featured_image'] = 'uploads/campaigns/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // Save campaign
        $this->load->model('Campaign_model');
        $campaign_id = $this->Campaign_model->add_campaign($campaignData);

        if ($campaign_id) {
            $this->session->set_flashdata('message', 'Campaign added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('campaigns-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Campaign, try again.']
            ]);
        }
    }

    public function delete_campaign($id)
    {
        $this->load->model('campaign_model');
        $this->campaign_model->delete_campaign($id);
        $this->session->set_flashdata('message', 'campaign delete successfully');
        redirect(base_url('campaigns-list'));

    }
    public function set_status($id)
    {
        $this->load->model('campaign_model');
        $new_status = $this->campaign_model->set_status($id);

        if ($new_status) {
            $this->session->set_flashdata('message', "campaign $new_status successfully");
        } else {
            $this->session->set_flashdata('message', "campaign not found");
        }

        redirect(base_url('campaigns-list'));
    }


    public function edit_campaign($id)
    {
        $this->load->model('campaign_model');
        $data['campaign'] = $this->campaign_model->get_campaign_by_id($id);
        $this->load->view('admin/edit-campaign', $data);
    }


    public function update_campaign()
    {
        log_message('debug', '🔹 update_campaign() called');

        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('description', 'Description', 'required|trim');
        $this->form_validation->set_rules('hindi_description', 'Hindi Description', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            log_message('error', '❌ Validation failed: ' . json_encode($_POST));
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'description' => form_error('description'),
                'hindi_description' => form_error('hindi_description'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $id = $this->input->post('id');
        log_message('debug', '🆔 Updating campaign ID: ' . $id);

        // Prepare base data
        $campaignData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'description' => $this->input->post('description'),
            'hindi_description' => $this->input->post('hindi_description'),
        ];

        // ✅ Handle optional image upload
        if (!empty($_FILES['featured_image']['name'])) {
            $config['upload_path'] = './uploads/campaigns/';
            $config['allowed_types'] = 'jpg|jpeg|png|webp';
            $config['max_size'] = 3072; // 3MB
            $config['file_name'] = time() . '_' . $_FILES['featured_image']['name'];

            // Ensure directory exists
            if (!is_dir($config['upload_path'])) {
                mkdir($config['upload_path'], 0777, true);
            }

            $this->load->library('upload', $config);

            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $campaignData['featured_image'] = 'uploads/campaigns/' . $uploadData['file_name'];

                log_message('debug', '🖼️ Image uploaded: ' . $campaignData['featured_image']);
            } else {
                log_message('error', '❌ Image upload error: ' . $this->upload->display_errors('', ''));
                echo json_encode(['status' => 'error', 'errors' => ['featured_image' => $this->upload->display_errors('', '')]]);
                return;
            }
        }

        $this->load->model('campaign_model');
        $updated = $this->campaign_model->update_campaign($id, $campaignData);

        if ($updated) {
            log_message('debug', '✅ Campaign updated successfully.');
            echo json_encode(['status' => 'success', 'redirect' => base_url('campaigns-list')]);
        } else {
            log_message('error', '❌ Failed to update campaign in DB.');
            echo json_encode(['status' => 'error', 'errors' => ['db' => 'Failed to update campaign, please try again.']]);
        }
    }




}