<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Counter extends CI_Controller
{
    public function index()
    {
        $this->load->view('admin/counter');
    }

    public function submit_counter()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('total_district', 'Category', 'required|trim');
        $this->form_validation->set_rules('total_village', 'Hindi Category', 'required|trim');
        $this->form_validation->set_rules('team_member', 'Hindi Category', 'required|trim');
        $this->form_validation->set_rules('Females_members', 'Hindi Category', 'required|trim');
        $this->form_validation->set_rules('milk_qty', 'Hindi Category', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'total_district' => form_error('total_district'),
                'total_village' => form_error('total_village'),
                'team_member' => form_error('team_member'),
                'Females_members' => form_error('Females_members'),
                'milk_qty' => form_error('milk_qty'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $counterData = [
            'total_district' => $this->input->post('total_district'),
            'total_village' => $this->input->post('total_village'),
            'team_member' => $this->input->post('team_member'),
            'Females_members' => $this->input->post('Females_members'),
            'milk_qty' => $this->input->post('milk_qty'),
        ];

        $this->load->model('counter_model');
        $insert_id = $this->counter_model->add_counter($counterData);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Counter added successfully!');
            echo json_encode(['status' => 'success']);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Counter, try again.']
            ]);
        }
    }

    public function get_counter_data()
    {
        $this->load->model('counter_model');
        $data = $this->counter_model->get_counter();

        if ($data) {
            echo json_encode(['status' => 'success', 'data' => $data]);
        } else {
            echo json_encode(['status' => 'error', 'message' => 'No data found']);
        }
    }


}