<?php
defined('BASEPATH') or exit('No direct script access allowed');

class News extends CI_Controller
{
    public function index()
    {
        $this->load->model('news_model');
        $data['category'] = $this->news_model->get_all_category();
        $this->load->view('admin/news-and-event-category', $data);
    }

    public function add_news_category()
    {
        $this->load->view('admin/add-news-and-event-category');
    }


    public function submit_news_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $newsCategory = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        $this->load->model('news_model');
        $insert_id = $this->news_model->add_news_category($newsCategory);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'News Category added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('news-and-event-category')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save News Category, try again.']
            ]);
        }
    }


    public function edit_news_category($id)
    {
        $this->load->model('news_model');
        $data['category'] = $this->news_model->get_news_category_by_id($id);
        $this->load->view('admin/edit-news-and-event-category', $data);
    }

    public function delete_news_category($id)
    {
        $this->load->model('news_model');
        $this->news_model->delete_news_category($id);
        $this->session->set_flashdata('message', 'news Category delete successfully');
        redirect(base_url('news-and-event-category'));

    }


    public function update_news_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get news ID
        $id = $this->input->post('id');

        // Prepare updated data
        $categoryData = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        // Upload folder config


        // Load model
        $this->load->model('news_model');
        // ✅ Update news
        $updated = $this->news_model->update_news_category($id, $categoryData);

        if ($updated) {
            $this->session->set_flashdata('message', 'news Category updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('news-and-event-category')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update news Category, please try again.']
            ]);
        }
    }

    public function news_and_event()
    {
        $this->load->model('news_model');
        $data['news'] = $this->news_model->get_all();
        $this->load->view('admin/news-and-event', $data);
    }

    public function add_news()
    {
        $this->load->model('news_model');
        $data['category'] = $this->news_model->get_all_category();
        $this->load->view('admin/add-news-and-event', $data);
    }
    public function submit_news()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('slug', 'Slug', 'required|trim');
        $this->form_validation->set_rules('hindi_slug', 'Hindi Slug', 'required|trim');
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'slug' => form_error('slug'),
                'hindi_slug' => form_error('hindi_slug'),
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
                'content' => form_error('content'),
                'hindi_content' => form_error('hindi_content'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $newsData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'slug' => $this->input->post('slug'),
            'hindi_slug' => $this->input->post('hindi_slug'),
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/news/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $newsData['featured_image'] = 'uploads/news/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_image' => 'Please select an image']
            ]);
            return;
        }

        // Save news
        $this->load->model('news_model');
        $news_id = $this->news_model->add_news($newsData);

        if ($news_id) {
            $this->session->set_flashdata('message', 'news added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('news-and-event-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save news, try again.']
            ]);
        }
    }
    public function delete_news($id)
    {
        $this->load->model('news_model');
        $this->news_model->delete_news($id);
        $this->session->set_flashdata('message', 'news delete successfully');
        redirect(base_url('news-and-event-list'));

    }
    public function set_status($id)
    {
        $this->load->model('news_model');
        $new_status = $this->news_model->set_status($id);

        if ($new_status) {
            $this->session->set_flashdata('message', "news $new_status successfully");
        } else {
            $this->session->set_flashdata('message', "news not found");
        }

        redirect(base_url('news-and-event-list'));
    }


    public function edit_news($id)
    {
        $this->load->model('news_model');
        $data['news'] = $this->news_model->get_news_by_id($id);
        $data['category'] = $this->news_model->get_all_category();
        $this->load->view('admin/edit-news', $data);
    }


    public function update_news()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('slug', 'Slug', 'required|trim');
        $this->form_validation->set_rules('hindi_slug', 'Hindi Slug', 'required|trim');
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'slug' => form_error('slug'),
                'hindi_slug' => form_error('hindi_slug'),
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
                'content' => form_error('content'),
                'hindi_content' => form_error('hindi_content'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get news ID
        $id = $this->input->post('id');

        // Prepare updated data
        $newsData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'slug' => $this->input->post('slug'),
            'hindi_slug' => $this->input->post('hindi_slug'),
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/news/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // Load model
        $this->load->model('news_model');

        // Get old image to delete if replaced
        $oldnews = $this->news_model->get_news_by_id($id);
        $oldImage = $oldnews ? $oldnews->featured_image : '';

        // ✅ If new image uploaded, replace old one
        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $newsData['featured_image'] = 'uploads/news/' . $uploadData['file_name'];

                // Delete old image (if exists)
                if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                    unlink('./' . $oldImage);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // ✅ Update news
        $updated = $this->news_model->update_news($id, $newsData);

        if ($updated) {
            $this->session->set_flashdata('message', 'news updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('news-and-event-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update news, please try again.']
            ]);
        }
    }
}