<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Product extends CI_Controller
{
    public function index()
    {
        $this->load->model('Product_model');
        $data['product'] = $this->Product_model->get_all_product();
        $this->load->view('admin/product', $data);
    }

    public function add_product()
    {
        $this->load->view('admin/add-product');
    }


    public function submit_product()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('product', 'Product', 'required|trim');
        $this->form_validation->set_rules(
            'slug',
            'Slug',
            'required|trim|regex_match[/^[a-z0-9-]+$/]',
            array(
                'regex_match' => 'The %s may only contain lowercase letters, numbers, and hyphens.'
            )
        );

        $this->form_validation->set_rules('hindi_product', 'Hindi Product', 'required|trim');
        $this->form_validation->set_rules(
            'hindi_slug',
            'Hindi Slug',
            'required|trim|regex_match[/^[\x{0900}-\x{097F}\s-]+$/u]',
            array(
                'regex_match' => 'The %s may only contain Hindi letters, spaces, and hyphens.'
            )
        );

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'product' => form_error('product'),
                'slug' => form_error('slug'),
                'hindi_product' => form_error('hindi_product'),
                'hindi_slug' => form_error('hindi_slug'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $productCategory = [
            'product' => $this->input->post('product'),
            'slug' => $this->input->post('slug'),
            'hindi_product' => $this->input->post('hindi_product'),
            'hindi_slug' => $this->input->post('hindi_slug'),
        ];

        $this->load->model('Product_model');
        $insert_id = $this->Product_model->add_product($productCategory);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Product added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('product-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Product, try again.']
            ]);
        }
    }

    public function edit_product($id)
    {
        $this->load->model('Product_model');
        $data['data'] = $this->Product_model->get_product_by_id($id);
        $this->load->view('admin/edit-product', $data);
    }




    public function update_product()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('product', 'Product', 'required|trim');
        $this->form_validation->set_rules(
            'slug',
            'Slug',
            'required|trim|regex_match[/^[a-z0-9-]+$/]',
            array(
                'regex_match' => 'The %s may only contain lowercase letters, numbers, and hyphens.'
            )
        );
        $this->form_validation->set_rules('hindi_product', 'Hindi Product', 'required|trim');
        $this->form_validation->set_rules(
            'hindi_slug',
            'Hindi Slug',
            'required|trim|regex_match[/^[\x{0900}-\x{097F}\s-]+$/u]',
            array(
                'regex_match' => 'The %s may only contain Hindi letters, spaces, and hyphens.'
            )
        );
        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'product' => form_error('product'),
                'slug' => form_error('slug'),
                'hindi_product' => form_error('hindi_product'),
                'hindi_slug' => form_error('hindi_slug'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $productData = [
            'product' => $this->input->post('product'),
            'slug' => $this->input->post('slug'),
            'hindi_product' => $this->input->post('hindi_product'),
            'hindi_slug' => $this->input->post('hindi_slug'),
        ];

        // Upload folder config


        // Load model
        $this->load->model('Product_model');
        // ✅ Update blog
        $updated = $this->Product_model->update_product($id, $productData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Product updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('product-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Product, please try again.']
            ]);
        }
    }

    public function delete_product($id)
    {
        $this->load->model('Product_model');
        $this->Product_model->delete_product($id);
        $this->session->set_flashdata('message', 'Product delete successfully');
        redirect(base_url('product-list'));

    }

    public function product_details()
    {
        $this->load->model('Product_model');
        $data['details'] = $this->Product_model->get_all_product_details();
        $this->load->view('admin/product-details', $data);
    }

    public function add_product_details()
    {
        $this->load->model('Product_model');
        $data['product'] = $this->Product_model->get_all_product();
        $this->load->view('admin/add-product-details', $data);
    }

    public function submit_product_details()
    {
        $this->form_validation->set_error_delimiters('', '');

        // === Validation rules ===
        $this->form_validation->set_rules('product_name', 'Product Name', 'required|trim');
        $this->form_validation->set_rules('hindi_product_name', 'Hindi Product Name', 'required|trim');
        $this->form_validation->set_rules('title_one', 'Title One', 'required|trim');
        $this->form_validation->set_rules('hindi_title_one', 'Hindi Title One', 'required|trim');
        $this->form_validation->set_rules('content_one', 'Content One', 'required|trim');
        $this->form_validation->set_rules('hindi_content_one', 'Hindi Content One', 'required|trim');
        $this->form_validation->set_rules('title_two', 'Title Two', 'required|trim');
        $this->form_validation->set_rules('hindi_title_two', 'Hindi Title Two', 'required|trim');
        $this->form_validation->set_rules('content_two', 'Content Two', 'required|trim');
        $this->form_validation->set_rules('hindi_content_two', 'Hindi Content Two', 'required|trim');
        $this->form_validation->set_rules('title_three', 'Title Three', 'required|trim');
        $this->form_validation->set_rules('hindi_title_three', 'Hindi Title Three', 'required|trim');
        $this->form_validation->set_rules('content_three', 'Content Three', 'required|trim');
        $this->form_validation->set_rules('hindi_content_three', 'Hindi Content Three', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'product_name' => form_error('product_name'),
                'hindi_product_name' => form_error('hindi_product_name'),
                'title_one' => form_error('title_one'),
                'hindi_title_one' => form_error('hindi_title_one'),
                'content_one' => form_error('content_one'),
                'hindi_content_one' => form_error('hindi_content_one'),
                'title_two' => form_error('title_two'),
                'hindi_title_two' => form_error('hindi_title_two'),
                'content_two' => form_error('content_two'),
                'hindi_content_two' => form_error('hindi_content_two'),
                'title_three' => form_error('title_three'),
                'hindi_title_three' => form_error('hindi_title_three'),
                'content_three' => form_error('content_three'),
                'hindi_content_three' => form_error('hindi_content_three'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data ===
        $productData = [
            'product_name' => $this->input->post('product_name'),
            'hindi_product_name' => $this->input->post('hindi_product_name'),
            'title_one' => $this->input->post('title_one'),
            'hindi_title_one' => $this->input->post('hindi_title_one'),
            'content_one' => $this->input->post('content_one'),
            'hindi_content_one' => $this->input->post('hindi_content_one'),
            'title_two' => $this->input->post('title_two'),
            'hindi_title_two' => $this->input->post('hindi_title_two'),
            'content_two' => $this->input->post('content_two'),
            'hindi_content_two' => $this->input->post('hindi_content_two'),
            'title_three' => $this->input->post('title_three'),
            'hindi_title_three' => $this->input->post('hindi_title_three'),
            'content_three' => $this->input->post('content_three'),
            'hindi_content_three' => $this->input->post('hindi_content_three'),
            'created_at' => date('Y-m-d H:i:s'),
        ];

        // === File Upload Config ===
        $uploadPath = './uploads/products/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120, // 5MB
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Handle Image Uploads ===
        $imageFields = [
            'featured_image_one',
            'featured_image_two',
            'featured_image_three',
        ];

        foreach ($imageFields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $uploadData = $this->upload->data();
                    $productData[$field] = 'uploads/products/' . $uploadData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => [$field => 'Please select an image for ' . str_replace('_', ' ', $field)]
                ]);
                return;
            }
        }

        // === Save Product ===
        $this->load->model('product_model');
        $product_id = $this->product_model->add_product_details($productData);

        if ($product_id) {
            $this->session->set_flashdata('message', 'Product details added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('product-details-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save product, please try again.']
            ]);
        }
    }

    public function edit_product_details($id)
    {
        $this->load->model('Product_model');
        $data['details'] = $this->Product_model->get_product_details_by_id($id);
        $data['product'] = $this->Product_model->get_all_product();
        $this->load->view('admin/edit-product-details', $data);
    }

    public function update_product_details()
    {
        $this->form_validation->set_error_delimiters('', '');

        // === Validation Rules ===
        $this->form_validation->set_rules('product_name', 'Product Name', 'required|trim');
        $this->form_validation->set_rules('hindi_product_name', 'Hindi Product Name', 'required|trim');
        $this->form_validation->set_rules('title_one', 'Title One', 'required|trim');
        $this->form_validation->set_rules('hindi_title_one', 'Hindi Title One', 'required|trim');
        $this->form_validation->set_rules('content_one', 'Content One', 'required|trim');
        $this->form_validation->set_rules('hindi_content_one', 'Hindi Content One', 'required|trim');
        $this->form_validation->set_rules('title_two', 'Title Two', 'required|trim');
        $this->form_validation->set_rules('hindi_title_two', 'Hindi Title Two', 'required|trim');
        $this->form_validation->set_rules('content_two', 'Content Two', 'required|trim');
        $this->form_validation->set_rules('hindi_content_two', 'Hindi Content Two', 'required|trim');
        $this->form_validation->set_rules('title_three', 'Title Three', 'required|trim');
        $this->form_validation->set_rules('hindi_title_three', 'Hindi Title Three', 'required|trim');
        $this->form_validation->set_rules('content_three', 'Content Three', 'required|trim');
        $this->form_validation->set_rules('hindi_content_three', 'Hindi Content Three', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'product_name' => form_error('product_name'),
                'hindi_product_name' => form_error('hindi_product_name'),
                'title_one' => form_error('title_one'),
                'hindi_title_one' => form_error('hindi_title_one'),
                'content_one' => form_error('content_one'),
                'hindi_content_one' => form_error('hindi_content_one'),
                'title_two' => form_error('title_two'),
                'hindi_title_two' => form_error('hindi_title_two'),
                'content_two' => form_error('content_two'),
                'hindi_content_two' => form_error('hindi_content_two'),
                'title_three' => form_error('title_three'),
                'hindi_title_three' => form_error('hindi_title_three'),
                'content_three' => form_error('content_three'),
                'hindi_content_three' => form_error('hindi_content_three'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data ===
        $id = $this->input->post('id');
        $productData = [
            'product_name' => $this->input->post('product_name'),
            'hindi_product_name' => $this->input->post('hindi_product_name'),
            'title_one' => $this->input->post('title_one'),
            'hindi_title_one' => $this->input->post('hindi_title_one'),
            'content_one' => $this->input->post('content_one'),
            'hindi_content_one' => $this->input->post('hindi_content_one'),
            'title_two' => $this->input->post('title_two'),
            'hindi_title_two' => $this->input->post('hindi_title_two'),
            'content_two' => $this->input->post('content_two'),
            'hindi_content_two' => $this->input->post('hindi_content_two'),
            'title_three' => $this->input->post('title_three'),
            'hindi_title_three' => $this->input->post('hindi_title_three'),
            'content_three' => $this->input->post('content_three'),
            'hindi_content_three' => $this->input->post('hindi_content_three'),
            'created_at' => date('Y-m-d H:i:s'),
        ];

        // === Upload Configuration ===
        $uploadPath = './uploads/product_details/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120,
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Helper to Handle Uploads ===
        $image_fields = ['featured_image_one', 'featured_image_two', 'featured_image_three'];

        // Fetch current record to delete old images
        $this->load->model('Product_model');
        $current = $this->Product_model->get_product_details($id);

        foreach ($image_fields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $uploadData = $this->upload->data();
                    $productData[$field] = 'uploads/product_details/' . $uploadData['file_name'];

                    // Delete old image if exists
                    if (!empty($current->$field) && file_exists(FCPATH . $current->$field)) {
                        unlink(FCPATH . $current->$field);
                    }
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        // === Update Database ===
        $updated = $this->Product_model->update_product_details($id, $productData);

        if ($updated) {
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('product-details-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update product details. Please try again.']
            ]);
        }
    }
    public function delete_product_details($id)
    {
        $this->load->model('Product_model');
        $this->Product_model->delete_product_details($id);
        $this->session->set_flashdata('message', 'Product details delete successfully');
        redirect(base_url('product-details-list'));

    }

}