<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Slider extends CI_Controller
{
    public function index()
    {
        $this->load->model('slider_model');
        $data['slider'] = $this->slider_model->get_all();
        $this->load->view('admin/sliders', $data);
    }

    public function add_slider()
    {
        $this->load->view('admin/add-slider');
    }

    public function submit_slider()
    {
        $this->load->model('slider_model');
        $this->load->library(['upload', 'form_validation']);

        $response = ['status' => 'error', 'errors' => []];

        // --- Form validation ---
        $this->form_validation->set_rules('title', 'Title', 'trim');
        $this->form_validation->set_rules('detail', 'Short Detail', 'trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'trim');
        $this->form_validation->set_rules('hindi_detail', 'Hindi Short Detail', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'detail' => form_error('detail'),
                'hindi_title' => form_error('hindi_title'),
                'hindi_detail' => form_error('hindi_detail'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // --- Image check ---
        if (empty($_FILES['slider_image']['name'][0])) {
            $response['errors']['image'] = 'Please upload at least one image.';
            echo json_encode($response);
            return;
        }

        // --- Upload setup ---
        $upload_path = './uploads/slider/';
        if (!is_dir($upload_path)) {
            mkdir($upload_path, 0777, true);
        }

        $uploaded_images = [];
        $filesCount = count($_FILES['slider_image']['name']);

        for ($i = 0; $i < $filesCount; $i++) {
            $_FILES['file']['name'] = $_FILES['slider_image']['name'][$i];
            $_FILES['file']['type'] = $_FILES['slider_image']['type'][$i];
            $_FILES['file']['tmp_name'] = $_FILES['slider_image']['tmp_name'][$i];
            $_FILES['file']['error'] = $_FILES['slider_image']['error'][$i];
            $_FILES['file']['size'] = $_FILES['slider_image']['size'][$i];

            $config = [
                'upload_path' => $upload_path,
                'allowed_types' => 'jpg|jpeg|png|gif',
                'max_size' => 50720, // ~50MB
                'encrypt_name' => TRUE
            ];

            $this->upload->initialize($config);

            if ($this->upload->do_upload('file')) {
                $uploadData = $this->upload->data();
                $uploaded_images[] = 'uploads/slider/' . $uploadData['file_name'];
            } else {
                $response['errors']['image'] = $this->upload->display_errors('', '');
                echo json_encode($response);
                return;
            }
        }

        // --- Save data in DB ---
        $all_inserted = true;
        foreach ($uploaded_images as $img) {
            $data = [
                'title' => $this->input->post('title'),
                'detail' => $this->input->post('detail'),
                'hindi_title' => $this->input->post('hindi_title'),
                'hindi_detail' => $this->input->post('hindi_detail'),
                'slider_image' => $img,
            ];

            $save = $this->slider_model->insert_slider($data);
            if (!$save) {
                $all_inserted = false;
            }
        }

        // --- Response ---
        if ($all_inserted) {
            $response = [
                'status' => 'success',
                'message' => 'Slider added successfully!',
                'redirect' => base_url('sliders-list')
            ];
        } else {
            $response['errors']['image'] = 'Failed to save some images.';
        }

        echo json_encode($response);
    }

    public function set_status($id)
    {
        $this->load->model('slider_model');
        $new_status = $this->slider_model->set_status($id);

        if ($new_status) {
            $this->session->set_flashdata('message', "Slider $new_status successfully");
        } else {
            $this->session->set_flashdata('message', "Slider not found");
        }

        redirect(base_url('sliders-list'));
    }

    public function edit_slider($id)
    {
        $this->load->model('slider_model');
        $data['slider'] = $this->slider_model->get_slider_by_id($id);
        $this->load->view('admin/edit-slider', $data);
    }

    public function update_slider()
    {
        $this->form_validation->set_error_delimiters('', '');

        // ✅ Validation rules
        $this->form_validation->set_rules('title', 'Title', 'trim');
        $this->form_validation->set_rules('detail', 'Short Detail', 'trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'trim');
        $this->form_validation->set_rules('hindi_detail', 'Hindi Short Detail', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'detail' => form_error('detail'),
                'hindi_title' => form_error('hindi_title'),
                'hindi_detail' => form_error('hindi_detail')
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // ✅ Get slider ID
        $id = $this->input->post('id');

        // ✅ Prepare updated data
        $sliderData = [
            'title' => $this->input->post('title'),
            'detail' => $this->input->post('detail'),
            'hindi_title' => $this->input->post('hindi_title'),
            'hindi_detail' => $this->input->post('hindi_detail'),
        ];

        // ✅ Upload folder config
        $uploadPath = './uploads/sliders/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);
        $this->load->model('slider_model');

        // ✅ Fetch old image from DB
        $oldSlider = $this->slider_model->get_slider_by_id($id);
        $oldImage = $oldSlider ? $oldSlider->slider_image : '';

        // ✅ Handle image upload (if new image selected)
        if (!empty($_FILES['slider_image']['name'][0])) {
            $filesCount = count($_FILES['slider_image']['name']);

            for ($i = 0; $i < $filesCount; $i++) {
                $_FILES['file']['name'] = $_FILES['slider_image']['name'][$i];
                $_FILES['file']['type'] = $_FILES['slider_image']['type'][$i];
                $_FILES['file']['tmp_name'] = $_FILES['slider_image']['tmp_name'][$i];
                $_FILES['file']['error'] = $_FILES['slider_image']['error'][$i];
                $_FILES['file']['size'] = $_FILES['slider_image']['size'][$i];

                if ($this->upload->do_upload('file')) {
                    $uploadData = $this->upload->data();
                    $sliderData['slider_image'] = 'uploads/sliders/' . $uploadData['file_name'];

                    // Delete old image if exists
                    if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                        unlink('./' . $oldImage);
                    }
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => ['image' => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        // ✅ Update record
        $updated = $this->slider_model->update_slider($id, $sliderData);

        if ($updated) {
            echo json_encode([
                'status' => 'success',
                'message' => 'Slider updated successfully!',
                'redirect' => base_url('sliders-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update slider. Please try again.']
            ]);
        }
    }


    public function delete_slider($id)
    {
        $this->load->model('slider_model');
        $this->slider_model->delete_slider($id);
        $this->session->set_flashdata('message', 'Slider Image delete successfully');
        redirect(base_url('sliders-list'));

    }
}