<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Tender extends CI_Controller
{
    public function index()
    {
        $this->load->model('tender_model');
        $data['tender'] = $this->tender_model->get_all();
        $this->load->view('admin/tander', $data);
    }

    public function add_tender()
    {
        $this->load->view('admin/add-tender');
    }


    public function submit_tender()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('hindi_subject', 'Hindi Subject', 'required|trim');
        $this->form_validation->set_rules('details', 'Details', 'required|trim');
        $this->form_validation->set_rules('hindi_details', 'Hindi Details', 'required|trim');
        $this->form_validation->set_rules('last_date', 'Last Date', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'subject' => form_error('subject'),
                'hindi_subject' => form_error('hindi_subject'),
                'details' => form_error('details'),
                'hindi_details' => form_error('hindi_details'),
                'last_date' => form_error('last_date'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $tarnderData = [
            'subject' => $this->input->post('subject'),
            'hindi_subject' => $this->input->post('hindi_subject'),
            'details' => $this->input->post('details'),
            'hindi_details' => $this->input->post('hindi_details'),
            'last_date' => $this->input->post('last_date'),
        ];

        // Upload folder config
        $uploadPath = './uploads/tender/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'pdf';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_file']['name'])) {
            if ($this->upload->do_upload('featured_file')) {
                $uploadData = $this->upload->data();
                $tarnderData['featured_file'] = 'uploads/tender/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_file' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_file' => 'Please select an image']
            ]);
            return;
        }

        // Save blog
        $this->load->model('tender_model');
        $blog_id = $this->tender_model->add_tender($tarnderData);

        if ($blog_id) {
            $this->session->set_flashdata('message', 'Tender added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('tender-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Tender, try again.']
            ]);
        }
    }

    public function edit_tender($id)
    {
        $this->load->model('tender_model');
        $data['tender'] = $this->tender_model->get_tender_by_id($id);
        $this->load->view('admin/edit-tender', $data);
    }


    public function update_tender()
    {
        // Always return JSON
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('subject', 'Subject', 'required|trim');
        $this->form_validation->set_rules('hindi_subject', 'Hindi Subject', 'required|trim');
        $this->form_validation->set_rules('details', 'Details', 'required|trim');
        $this->form_validation->set_rules('hindi_details', 'Hindi Details', 'required|trim');
        $this->form_validation->set_rules('last_date', 'Last Date', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'subject' => form_error('subject'),
                'hindi_subject' => form_error('hindi_subject'),
                'details' => form_error('details'),
                'hindi_details' => form_error('hindi_details'),
                'last_date' => form_error('last_date'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get ID
        $id = $this->input->post('id');
        if (empty($id)) {
            echo json_encode(['status' => 'error', 'errors' => ['general' => 'Invalid request.']]);
            return;
        }

        // Prepare updated data
        $tarnderData = [
            'subject' => $this->input->post('subject'),
            'hindi_subject' => $this->input->post('hindi_subject'),
            'details' => $this->input->post('details'),
            'hindi_details' => $this->input->post('hindi_details'),
            'last_date' => $this->input->post('last_date'),
        ];

        // Upload config (allow images + pdf)
        $uploadPath = './uploads/tender/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg|pdf',
            'max_size' => 5120, // 5MB in KB (CI expects KB)
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload');
        $this->upload->initialize($config);

        // Load model
        $this->load->model('tender_model');

        // Get old record (to delete file if replaced)
        $oldTender = $this->tender_model->get_tender_by_id($id);
        $oldImage = $oldTender ? $oldTender->featured_file : '';

        // If a new file is present in $_FILES and has a name => process upload
        if (!empty($_FILES) && isset($_FILES['featured_file']) && !empty($_FILES['featured_file']['name'])) {
            if ($this->upload->do_upload('featured_file')) {
                $uploadData = $this->upload->data();
                // Save relative path
                $tarnderData['featured_file'] = 'uploads/tender/' . $uploadData['file_name'];

                // Delete old file if exists and not empty
                if (!empty($oldImage) && file_exists(FCPATH . $oldImage)) {
                    @unlink(FCPATH . $oldImage);
                }
            } else {
                // Upload failed
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_file' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }
        // else: no new file uploaded -> keep existing featured_file untouched

        // Update record
        $updated = $this->tender_model->update_tender($id, $tarnderData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Tender updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('tender-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Tender, please try again.']
            ]);
        }
    }
    public function delete_tender($id)
    {
        $this->load->model('tender_model');
        $this->tender_model->delete_tender($id);
        $this->session->set_flashdata('message', 'Tender delete successfully');
        redirect(base_url('tender-list'));

    }
}