<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Theme_color extends CI_Controller
{
    public function save_color()
    {
        // Load model
        $this->load->model('Theme_color_model');

        // Receive AJAX color
        $color = $this->input->post('color_name');

        if (!$color) {
            echo json_encode([
                'status' => false,
                'message' => 'Color is required'
            ]);
            return;
        }

        // Step 1: Delete all old colors
        $this->db->empty_table('theme_color');

        // Step 2: Insert NEW color
        $data = ['color_name' => $color];
        $insert = $this->Theme_color_model->insert_color($data);

        if ($insert) {
            echo json_encode([
                'status' => true,
                'message' => 'New theme color saved'
            ]);
        } else {
            echo json_encode([
                'status' => false,
                'message' => 'Failed to save color'
            ]);
        }
    }


}