<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Unpaid_history extends CI_Controller
{
    public function index()
    {
        $this->load->model('unpaid_model');
        $data['unpaid'] = $this->unpaid_model->get_all();
        $this->load->view('admin/unpaid-history', $data);
    }

    public function add_unpaid_history()
    {
        $this->load->view('admin/add-unpaid-history');
    }


    public function submit_unpaid_history()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('year', 'Year', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'year' => form_error('year'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $historyData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'year' => $this->input->post('year'),
        ];

        // Upload folder config
        $uploadPath = './uploads/history/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'pdf';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_file']['name'])) {
            if ($this->upload->do_upload('featured_file')) {
                $uploadData = $this->upload->data();
                $historyData['featured_file'] = 'uploads/history/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_file' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_file' => 'Please select an image']
            ]);
            return;
        }

        // Save blog
        $this->load->model('unpaid_model');
        $history_id = $this->unpaid_model->add_history($historyData);

        if ($history_id) {
            $this->session->set_flashdata('message', 'Unpaid History added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('unpaid-history-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Unpaid History, try again.']
            ]);
        }
    }

    public function edit_unpaid_history($id)
    {
        $this->load->model('unpaid_model');
        $data['report'] = $this->unpaid_model->get_history_by_id($id);
        $this->load->view('admin/edit-unpaid-history', $data);
    }


    public function update_unpaid_history()
    {
        // Always return JSON
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('year', 'Year', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'year' => form_error('year'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }



        // Get ID
        $id = $this->input->post('id');
        if (empty($id)) {
            echo json_encode(['status' => 'error', 'errors' => ['general' => 'Invalid request.']]);
            return;
        }

        // Prepare updated data
        $historyData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'year' => $this->input->post('year'),
        ];

        // Upload config (allow images + pdf)
        $uploadPath = './uploads/history/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg|pdf',
            'max_size' => 5120, // 5MB in KB (CI expects KB)
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload');
        $this->upload->initialize($config);

        // Load model
        $this->load->model('unpaid_model');

        // Get old record (to delete file if replaced)
        $oldTender = $this->unpaid_model->get_history_by_id($id);
        $oldImage = $oldTender ? $oldTender->featured_file : '';

        // If a new file is present in $_FILES and has a name => process upload
        if (!empty($_FILES) && isset($_FILES['featured_file']) && !empty($_FILES['featured_file']['name'])) {
            if ($this->upload->do_upload('featured_file')) {
                $uploadData = $this->upload->data();
                // Save relative path
                $historyData['featured_file'] = 'uploads/history/' . $uploadData['file_name'];

                // Delete old file if exists and not empty
                if (!empty($oldImage) && file_exists(FCPATH . $oldImage)) {
                    @unlink(FCPATH . $oldImage);
                }
            } else {
                // Upload failed
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_file' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }
        // else: no new file uploaded -> keep existing featured_file untouched

        // Update record
        $updated = $this->unpaid_model->update_history($id, $historyData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Unpaid History updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('unpaid-history-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Unpaid History, please try again.']
            ]);
        }
    }
    public function delete_report($id)
    {
        $this->load->model('unpaid_model');
        $this->unpaid_model->delete_history($id);
        $this->session->set_flashdata('message', 'Unpaid History delete successfully');
        redirect(base_url('unpaid-history-list'));

    }

}