<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Award_model extends CI_Model
{
    public function add_award($data)
    {
        $this->db->insert('award', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }

    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('award')->result();
    }

    public function get_award_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('award')->row();
    }

    public function update_award($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('award', $data);
    }

    public function delete_award($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('award');
        return $this->db->affected_rows();
    }
}