<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Blog_model extends CI_Model
{

    public function add_blog_category($data)
    {
        $this->db->insert('blog_category', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }

    public function get_all_category()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('blog_category')->result();
    }

    public function get_blog_category_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('blog_category')->row();
    }

    public function update_blog_category($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('blog_category', $data);
    }

    public function delete_blog_category($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('blog_category');
        return $this->db->affected_rows();
    }



    public function add_blog($data)
    {
        $this->db->insert('blogs', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('blogs')->result();
    }
    public function edit_blog($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('blogs', $data);
        return $this->db->affected_rows();
    }
    public function get_blog_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('blogs')->row();
    }



    public function delete_blog($id)
    {
        // Step 1: Fetch file path from DB
        $this->db->select('featured_image');
        $this->db->from('blogs');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete image file if it exists
        if (!empty($row) && !empty($row->featured_image)) {
            $image_path = FCPATH . $row->featured_image;
            if (file_exists($image_path)) {
                unlink($image_path); // Delete the file from folder
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('blogs');

        // Step 4: Optional - return status
        if ($this->db->affected_rows() > 0) {
            return true; // Deleted successfully
        } else {
            return false; // Something went wrong
        }
    }
    public function set_status($id)
    {
        // Get current status
        $this->db->select('status');
        $this->db->from('blogs');
        $this->db->where('id', $id);
        $blog = $this->db->get()->row();

        if ($blog) {
            // Toggle status
            $new_status = ($blog->status == 'active') ? 'inactive' : 'active';

            // Update status in database
            $this->db->where('id', $id);
            $this->db->update('blogs', ['status' => $new_status]);

            return $new_status; // return new status to controller
        }

        return false; // blog not found
    }

    public function update_blog($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('blogs', $data);
    }


    public function get_blog_by_title($slug)
    {
        $this->db->where('slug', $slug);
        return $this->db->get('blogs')->row();
    }

    public function get_blogs_by_category($category)
    {
        $this->db->select('*');
        $this->db->from('blogs');
        $this->db->where('category', $category);
        return $this->db->get()->result();
    }

}