<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Campaign_model extends CI_Model
{

    public function add_campaign($data)
    {
        $this->db->insert('campaigns', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('campaigns')->result();
    }

    public function get_campaign_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('campaigns')->row();
    }
    public function update_campaign($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('campaigns', $data);
        return $this->db->trans_status(); // true/false based on query success
    }


    public function delete_campaign($id)
    {
        // Step 1: Get all image filenames from database
        $this->db->select('featured_image');
        $this->db->from('campaigns');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete each image if it exists
        if (!empty($row)) {
            $images = [
                $row->featured_image
            ];

            foreach ($images as $img) {
                if (!empty($img)) {
                    $image_path = FCPATH . $img; // Full path
                    if (file_exists($image_path)) {
                        unlink($image_path); // Delete image file
                    }
                }
            }
        }
    }
    public function set_status($id)
    {
        // Get current status
        $this->db->select('status');
        $this->db->from('campaigns');
        $this->db->where('id', $id);
        $campaign = $this->db->get()->row();

        if ($campaign) {
            // Toggle status
            $new_status = ($campaign->status == 'active') ? 'inactive' : 'active';

            // Update status in database
            $this->db->where('id', $id);
            $this->db->update('campaigns', ['status' => $new_status]);

            return $new_status; // return new status to controller
        }

        return false; // campaign not found
    }

    public function get_active_campaign()
    {
        return $this->db
            ->where('status', 'active')
            ->order_by('id', 'desc')
            ->get('campaigns')
            ->result();
    }
}