<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Counter_model extends CI_Model
{
    public function add_counter($data)
    {
        // Check if table already has data
        $query = $this->db->get('counter');

        if ($query->num_rows() > 0) {
            // Update existing record (only one row expected)
            $this->db->update('counter', $data);
            return $this->db->affected_rows() > 0 ? true : false;
        } else {
            // Insert new record
            $this->db->insert('counter', $data);
            if ($this->db->affected_rows() > 0) {
                return $this->db->insert_id();
            } else {
                return false;
            }
        }
    }

    public function get_counter()
    {
        $query = $this->db->get('counter');
        if ($query->num_rows() > 0) {
            return $query->row_array(); // return single row as array
        } else {
            return false;
        }
    }
    
        public function increase_count()
    {
        $query = $this->db->get('visit_counter');

        if ($query->num_rows() == 0) {
            // अगर कोई row नहीं है तो पहली बार create करो
            $this->db->insert('visit_counter', ['total_visits' => 1]);
        } else {
            // अगर row है तो count बढ़ाओ
            $this->db->set('total_visits', 'total_visits + 1', FALSE);
            $this->db->update('visit_counter');
        }
    }

    public function get_count()
    {
        $query = $this->db->get('visit_counter')->row();
        return $query ? $query->total_visits : 0;
    }
}