<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dividend_model extends CI_Model
{

    public function add_dividend_history($data)
    {
        $this->db->insert('dividend_history', $data);
        if ($this->db->affected_rows() > 0) {
            return $this->db->insert_id(); // return insert ID
        } else {
            return false;
        }
    }

    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('dividend_history')->result();
    }

    public function get_dividend_history_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('dividend_history')->row();
    }

    public function update_dividend_history($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('dividend_history', $data);
    }

    public function delete_dividend_history($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('dividend_history');
        return $this->db->affected_rows();
    }
}