<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Team_model extends CI_Model
{

    public function add_team($data)
    {
        $this->db->insert('team', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('team')->result();
    }

    public function edit_team($id, $data)
    {
        $this->db->where('id', $id);
        $this->db->update('team', $data);
        return $this->db->affected_rows();
    }
    public function get_team_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('team')->row();
    }
    public function delete_team($id)
    {
        $this->db->where('id', $id);
        $this->db->delete('team');
        return $this->db->affected_rows();
    }

    public function update_team($id, $data)
    {
        $this->db->where('id', $id);
        return $this->db->update('team', $data);
    }

    public function get_all_team()
    {

        return $this->db->get('team')->result();
    }

    public function get_team_by_name($name)
    {
        $this->db->where('name', $name);
        return $this->db->get('team')->row();
    }
}