<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Tender_model extends CI_Model
{
    public function add_tender($data)
    {
        $this->db->insert('tender', $data);
        return $this->db->insert_id();
    }
    public function get_all()
    {
        $this->db->order_by('id', 'desc');
        return $this->db->get('tender')->result();
    }


    public function update_tender($id, $data)
    {
        $this->db->where('id', $id);
        // db->update returns boolean true/false in CI
        return $this->db->update('tender', $data);
    }

    public function get_tender_by_id($id)
    {
        $this->db->where('id', $id);
        return $this->db->get('tender')->row();
    }


    public function delete_tender($id)
    {
        // Step 1: Fetch file path from DB
        $this->db->select('featured_file');
        $this->db->from('tender');
        $this->db->where('id', $id);
        $query = $this->db->get();
        $row = $query->row();

        // Step 2: Delete image file if it exists
        if (!empty($row) && !empty($row->featured_file)) {
            $image_path = FCPATH . $row->featured_file;
            if (file_exists($image_path)) {
                unlink($image_path); // Delete the file from folder
            }
        }

        // Step 3: Delete record from database
        $this->db->where('id', $id);
        $this->db->delete('tender');

        // Step 4: Optional - return status
        if ($this->db->affected_rows() > 0) {
            return true; // Deleted successfully
        } else {
            return false; // Something went wrong
        }
    }

}