<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Add Product | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Add Product</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-6">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Add Product</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="productForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <div class="col-md-12">
                                        <label for="validationCustom01" class="form-label">Product</label>
                                        <input type="text" class="form-control" id="validationCustom01" name="product"
                                            required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-product" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="validationCustom02" class="form-label">Hindi Product</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="hindi_product" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-hindi_product" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="validationCustom05" class="form-label">Slug</label>
                                        <input type="text" class="form-control" id="validationCustom05" name="slug"
                                            required>
                                        <span class="small">
                                            Only <strong>small letters (a-z)</strong>, <strong>numbers (0-9)</strong>,
                                            and
                                            <strong>hyphens (-)</strong> are allowed in the slug.<br>
                                            Special symbols such as <code>@</code>, <code>#</code>, <code>$</code>,
                                            <code>%</code>, <code>&</code>, <code>*</code>, <code>_</code>,
                                            <code>/</code>, <code>?</code>, <code>!</code>, etc. are <strong>not
                                                allowed</strong>.
                                        </span>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Slug.</div>
                                        <span id="error-slug" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="validationCustom06" class="form-label">Hindi Slug</label>
                                        <input type="text" class="form-control" id="validationCustom06"
                                            name="hindi_slug" required>
                                        <span class="small">
                                            Only <strong>small letters (a-z)</strong>, <strong>numbers (0-9)</strong>,
                                            and
                                            <strong>hyphens (-)</strong> are allowed in the slug.<br>
                                            Special symbols such as <code>@</code>, <code>#</code>, <code>$</code>,
                                            <code>%</code>, <code>&</code>, <code>*</code>, <code>_</code>,
                                            <code>/</code>, <code>?</code>, <code>!</code>, etc. are <strong>not
                                                allowed</strong>.
                                        </span>
                                        <div class="valid-feedback"> Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Slug.</div>
                                        <span id="error-hindi_slug" class="text-danger error"></span>
                                    </div>
                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>

                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {

            $("#productForm").on("submit", function (e) {
                e.preventDefault(); // prevent page reload
                $(".error").html(""); // clear old errors

                // Create FormData object
                var formData = new FormData(this);

                $.ajax({
                    url: "<?= base_url('admin/product/submit_product') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });
            });
        });
    </script>

</body>

</html>