<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Create New Account | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <?php include_once('common_page/links.php') ?>
</head>

<body>

    <div class="auth-box overflow-hidden align-items-center d-flex">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-xxl-4 col-md-6 col-sm-8">
                    <div class="card p-4">

                        <div class="auth-brand text-center mb-4">
                            <a href="" class="logo-dark">
                                <img src="<?= base_url() ?>assets/img/logo/Logo.png" alt="dark logo" height="80">
                            </a>
                            <a href="" class="logo-light">
                                <img src="<?= base_url() ?>assets/img/logo/Logo.png" alt="logo" height="80">
                            </a>
                            <p class="text-muted w-lg-75 mt-3 mx-auto">Let’s get you started. Create your account by
                                entering your details below.</p>
                        </div>

                        <form action="<?= base_url('admin/login/add_admin') ?>" method="POST">
                            <div class="mb-3">
                                <label for="userName" class="form-label">Name <span class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="userName" name="name" required>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="userEmail" class="form-label">Email address <span
                                        class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="email" class="form-control" id="userEmail"
                                        placeholder="you@example.com" name="email" required>
                                </div>
                            </div>

                            <div class="mb-3" data-password="bar">
                                <label for="userPassword" class="form-label">Password <span
                                        class="text-danger">*</span></label>
                                <div class="input-group">
                                    <input type="password" class="form-control" id="userPassword" name="password"
                                        placeholder="••••••••" required>
                                </div>
                                <div class="password-bar my-2"></div>
                                <p class="text-muted fs-xs mb-0">Use 8+ characters with letters, numbers & symbols.</p>
                            </div>

                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary fw-semibold py-2">Create Account</button>
                            </div>
                        </form>

                        <p class="text-muted text-center mt-4 mb-0">
                            Already have an account? <a href="<?= base_url() ?>login"
                                class="text-decoration-underline link-offset-3 fw-semibold">Login</a>
                        </p>
                    </div>

                    <p class="text-center text-muted mt-4 mb-0">
                        ©
                        <script>document.write(new Date().getFullYear())</script> Maalav Milk,
                        <span class="fw-semibold">Developed by <a href="http://namami.co.in/" target="blank">Namami
                                Software</a></span>

                    </p>
                </div>
            </div>
        </div>
    </div>
    <!-- end auth-fluid-->

    <!-- Vendor js -->
    <script src="assets/js/vendors.min.js"></script>

    <!-- App js -->
    <script src="assets/js/app.js"></script>

    <!-- Password Suggestion Js -->
    <script src="assets/js/pages/auth-password.js"></script>

</body>

</html>