<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Counter | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">

                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Counters</h4>
                    </div>


                </div>

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="counterForm" method="POST"
                                    enctype="multipart/form-data">
                                    <div class="col-md-2">
                                        <label for="validationCustom01" class="form-label">Total District</label>
                                        <input type="text" class="form-control" id="validationCustom01"
                                            name="total_district" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Total District.</div>
                                        <span id="error-total_district" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="validationCustom02" class="form-label">Total Village</label>
                                        <input type="text" class="form-control" id="validationCustom02"
                                            name="total_village" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Total Village.</div>
                                        <span id="error-total_village" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="validationCustom03" class="form-label">Team Member</label>
                                        <input type="text" class="form-control" id="validationCustom03"
                                            name="team_member" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Team Member.</div>
                                        <span id="error-team_member" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="validationCustom04" class="form-label">Females Members</label>
                                        <input type="text" class="form-control" id="validationCustom04"
                                            name="Females_members" required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Females Members.</div>
                                        <span id="error-Females_members" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-2">
                                        <label for="validationCustom05" class="form-label">Milk Qty (LLPD)</label>
                                        <input type="text" class="form-control" id="validationCustom05" name="milk_qty"
                                            required>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid Milk Qty (LLPD).</div>
                                        <span id="error-milk_qty" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12 row mt-2">
                                        <div class="col-auto">
                                            <button class="btn btn-primary" type="submit">Submit Form</button>
                                        </div>
                                        <div class="col-auto">
                                            <div class="status-button-container" data-section="counters">
                                                <button class="btn btn-secondary" disabled>
                                                    Loading...
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div> <!-- end card-->
                    </div>
                </div>

                <div class="row row-cols-xxl-4 row-cols-md-2 row-cols-1">
                    <!-- Total Sales Widget -->

                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                        <span class="avatar-title bg-primary-subtle text-primary rounded-circle fs-24">
                                            <i class="fas fa-search"></i>
                                        </span>
                                    </div>
                                    <div class="text-end">
                                        <h3 class="mb-2 fw-normal"><span id="total_district">0</span>
                                        </h3>
                                        <p class="mb-0 text-muted"><span>Total Districts</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                    <!-- Refund Requests Widget -->
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                        <span class="avatar-title bg-warning-subtle text-warning rounded-circle fs-24">
                                            <i class="fas fa-user"></i>
                                        </span>
                                    </div>
                                    <div class="text-end">
                                        <h3 class="mb-2 fw-normal">
                                            <span id="total_village">0</span>
                                        </h3>
                                        <p class="mb-0 text-muted"><span>Total Village</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                        <span class="avatar-title bg-primary-subtle text-primary rounded-circle fs-24">
                                            <i class="fas fa-search"></i>
                                        </span>
                                    </div>
                                    <div class="text-end">
                                        <h3 class="mb-2 fw-normal"><span id="team_member">0</span>
                                        </h3>
                                        <p class="mb-0 text-muted"><span>Team Members</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                    <!-- Orders Placed Widget -->
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                        <span class="avatar-title bg-success-subtle text-success rounded-circle fs-24">
                                            <i class="fas fa-blog"></i>
                                        </span>
                                    </div>
                                    <div class="text-end">
                                        <h3 class="mb-2 fw-normal">
                                            <span id="Females_members">0</span>
                                        </h3>
                                        <p class="mb-0 text-muted"><span>Females Members</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->

                    <!-- Active Customers Widget -->
                    <div class="col">
                        <div class="card">
                            <div class="card-body">
                                <div class="d-flex justify-content-between align-items-center">
                                    <div class="avatar fs-60 avatar-img-size flex-shrink-0">
                                        <span class="avatar-title bg-info-subtle text-info rounded-circle fs-24">
                                            <i class="fas fa-quote-left"></i>
                                        </span>
                                    </div>
                                    <div class="text-end">
                                        <h3 class="mb-2 fw-normal">
                                            <span id="milk_qty">0</span>
                                        </h3>
                                        <p class="mb-0 text-muted"><span>Milk Qty (LLPD)</span></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div><!-- end col -->


                </div>


            </div>
            <!-- container -->

            <?php if ($this->session->flashdata('message')): ?>
                <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999">
                    <div id="flashToast" class="toast align-items-center text-bg-success border-0 shadow-lg mt-3"
                        role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body fw-semibold">
                                <?= $this->session->flashdata('message'); ?>
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                                aria-label="Close"></button>
                        </div>
                    </div>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        var toastEl = document.getElementById('flashToast');
                        var toast = new bootstrap.Toast(toastEl, { delay: 3000 });
                        toast.show();
                    });
                </script>
            <?php endif; ?>


            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>

    <script>
        $(document).ready(function () {

            // ✅ Handle form submit
            $("#counterForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                // ❌ Disable default browser validation messages
                this.classList.remove("was-validated");

                var formData = new FormData(this);

                $.ajax({
                    url: "<?= base_url('admin/counter/submit_counter') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                                $("[name='" + key + "']").addClass("is-invalid");
                            });
                        } else if (response.status === "success") {
                            $("#counterForm")[0].reset();
                            $("#counterForm").find(".is-invalid").removeClass("is-invalid");
                            $(".error").html("");
                            fetchCounterData();
                            showToast("Counter saved successfully!");
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });
            });

            // ✅ Fetch counter data on page load
            fetchCounterData();

            function fetchCounterData() {
                $.ajax({
                    url: "<?= base_url('admin/counter/get_counter_data') ?>",
                    type: "GET",
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "success" && response.data) {
                            let data = response.data;

                            // ✅ Update display values
                            $("#total_district").text(data.total_district || "0");
                            $("#total_village").text(data.total_village || "0");
                            $("#team_member").text(data.team_member || "0");
                            $("#Females_members").text(data.females_members || "0");
                            $("#milk_qty").text(data.milk_qty || "0");
                        } else {
                            // No data found → reset display to 0
                            $("#total_district, #total_village, #team_member, #Females_members, #milk_qty").text("0");
                        }
                    },
                    error: function (xhr) {
                        console.log(xhr.responseText);
                    }
                });
            }

            // ✅ Toast function for success message
            function showToast(message) {
                let toastHTML = `
            <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999">
                <div class="toast align-items-center text-bg-success border-0 shadow-lg mt-3"
                    role="alert" aria-live="assertive" aria-atomic="true">
                    <div class="d-flex">
                        <div class="toast-body fw-semibold">
                            ${message}
                        </div>
                        <button type="button" class="btn-close btn-close-white me-2 m-auto"
                            data-bs-dismiss="toast" aria-label="Close"></button>
                    </div>
                </div>
            </div>
        `;

                $(".toast-container").remove(); // remove old toast
                $("body").append(toastHTML);

                var toastEl = document.querySelector('.toast');
                var toast = new bootstrap.Toast(toastEl, { delay: 3000 });
                toast.show();
            }
        });
    </script>


    <script>
        $(document).ready(function () {

            var container = $('.status-button-container');
            var sectionName = container.data('section');

            // Page load hone par status check karein
            checkStatus(sectionName);

            // Function: Database se status check karke button show karna
            function checkStatus(section_name) {
                $.ajax({
                    url: '<?php echo base_url("admin/section/check_status"); ?>',
                    type: 'POST',
                    data: {
                        section_name: section_name,
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            var buttonHtml = '';

                            // Current status ke opposite button dikhayen
                            if (response.status == 'active') {
                                // Active hai toh Inactive button dikhayen
                                buttonHtml = '<a href="javascript:void(0)" class="btn btn-danger status-toggle" data-current="active" data-section="' + section_name + '">Inactive</a>';
                            } else if (response.status == 'inactive') {
                                // Inactive hai toh Active button dikhayen
                                buttonHtml = '<a href="javascript:void(0)" class="btn btn-success status-toggle" data-current="inactive" data-section="' + section_name + '">Active</a>';
                            } else {
                                buttonHtml = '<span class="text-warning">Unknown Status</span>';
                            }

                            container.html(buttonHtml);

                        } else {
                            container.html('<span class="text-danger">Error: ' + response.message + '</span>');
                        }
                    },
                    error: function () {
                        container.html('<span class="text-danger">Error loading status</span>');
                    }
                });
            }

            // Status toggle button click event (dynamically created button ke liye)
            $(document).on('click', '.status-toggle', function () {
                var button = $(this);
                var currentStatus = button.data('current'); // 'active' or 'inactive'
                var section_name = button.data('section');

                // New status determine karein (opposite of current)
                var newStatus = currentStatus == 'active' ? 'inactive' : 'active';

                // Button disable karein
                button.prop('disabled', true);
                button.html('<i class="fa fa-spinner fa-spin"></i> Updating...');

                // Ajax request se status update karein
                $.ajax({
                    url: '<?php echo base_url("admin/section/update_status"); ?>',
                    type: 'POST',
                    data: {
                        section_name: section_name,
                        status: newStatus,
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {
                            // Button update karein - opposite button dikhayen
                            if (newStatus == 'active') {
                                // Ab active ho gaya, toh Inactive button dikhayen
                                button.removeClass('btn-success').addClass('btn-danger');
                                button.text('Inactive');
                                button.data('current', 'active');
                            } else {
                                // Ab inactive ho gaya, toh Active button dikhayen
                                button.removeClass('btn-danger').addClass('btn-success');
                                button.text('Active');
                                button.data('current', 'inactive');
                            }

                            // Success message
                            alert('Status successfully updated to ' + newStatus + '!');
                        } else {
                            alert('Error: ' + response.message);
                            // Error hone par fresh status load karein
                            checkStatus(section_name);
                        }
                    },
                    error: function (xhr, status, error) {
                        alert('Ajax error: ' + error);
                        // Error hone par fresh status load karein
                        checkStatus(section_name);
                    },
                    complete: function () {
                        button.prop('disabled', false);
                    }
                });
            });

        });
    </script>
</body>

</html>