<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit campaign | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit campaign</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit campaign</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" id="campaignForm" method="POST"
                                    enctype="multipart/form-data" novalidate>
                                    <input type="hidden" name="id" value="<?= $campaign->id ?>">

                                    <div class="col-md-6">
                                        <label class="form-label">Title</label>
                                        <input type="text" class="form-control" name="title"
                                            value="<?= $campaign->title ?>" required>
                                        <span id="error-title" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label class="form-label">Hindi Title</label>
                                        <input type="text" class="form-control" name="hindi_title"
                                            value="<?= $campaign->hindi_title ?>" required>
                                        <span id="error-hindi_title" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label for="description" class="form-label">Description</label>
                                        <textarea name="description" id="description" class="form-control"
                                            required><?= $campaign->description ?></textarea>
                                        <span id="error-description" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label for="hindi_description" class="form-label">Hindi Description</label>
                                        <textarea name="hindi_description" id="hindi_description" class="form-control"
                                            required><?= $campaign->hindi_description ?></textarea>
                                        <span id="error-hindi_description" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-12">
                                        <label for="featured_image" class="form-label">
                                            Image<small><sup>(Optional)</sup></small>
                                        </label>
                                        <div class="filepond-uploader">
                                            <input type="file" id="featured_image" name="featured_image"
                                                class="filepond filepond-input-multiple form-control"
                                                data-allow-reorder="true" data-max-file-size="3MB" data-max-files="1"
                                                aria-label="file example">
                                        </div>

                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid image.</div>
                                        <span id="error-featured_image" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>


                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


    <script>
        $(document).ready(function () {


            // ✅ Handle form submit
            $("#campaignForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                const formData = new FormData(this);

                $.ajax({
                    url: "<?= base_url('admin/campaign/update_campaign') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.error("AJAX Error:", xhr.responseText);
                    }
                });
            });
        });

    </script>




</body>

</html>