<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Edit Gallery | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Edit Gallery</h4>
                    </div>


                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title">Edit Gallery</h4>
                            </div>

                            <div class="card-body">
                                <form class="row g-3 needs-validation" novalidate id="galleryForm" method="POST"
                                    enctype="multipart/form-data">
                                    <input type="hidden" name="id" value="<?= $gallery->id ?>">
                                    <div class="col-md-6">
                                        <label for="validationCustom01" class="form-label">Gallery Category</label>
                                        <select name="gallery_category" id="validationCustom01" class="form-select">
                                            <option value="<?= $gallery->gallery_category ?>">
                                                <?= $gallery->gallery_category ?>
                                            </option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->category ?>"><?= $data->category ?></option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-gallery_category" class="text-danger error"></span>
                                    </div>
                                    <div class="col-md-6">
                                        <label for="validationCustom02" class="form-label">Hindi Gallery
                                            Category</label>
                                        <select name="hindi_gallery_category" id="validationCustom02"
                                            class="form-select">
                                            <option value="<?= $gallery->hindi_gallery_category ?>">
                                                <?= $gallery->hindi_gallery_category ?>
                                            </option>
                                            <?php foreach ($category as $data): ?>
                                                <option value="<?= $data->hindi_category ?>"><?= $data->hindi_category ?>
                                                </option>
                                            <?php endforeach; ?>
                                        </select>
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid hindi category.</div>
                                        <span id="error-hindi_gallery_category" class="text-danger error"></span>
                                    </div>

                                    <div class="col-md-6">
                                        <label for="validationCustom03" class="form-label">Year</label>
                                        <input type="number" id="validationCustom03" name="year" class="form-control"
                                            maxlength="4" value="<?= $gallery->year ?>"
                                            oninput="if(this.value.length > 4) this.value = this.value.slice(0,4);" />
                                        <div class="valid-feedback">Looks great!</div>
                                        <div class="invalid-feedback">Please choose a valid category.</div>
                                        <span id="error-year" class="text-danger error"></span>
                                    </div>
                                    <div>
                                        <h5 class="mb-3">Gallery Images</h5>
                                        <div class="filepond-uploader three-grid">
                                            <input type="file" class="filepond filepond-input-multiple" multiple
                                                name="gallery_image" data-allow-reorder="true" data-max-file-size="3MB"
                                                data-max-files="1" value="<?= $gallery->gallery_image ?>" required>
                                        </div>
                                        <span id="error-image" class="text-danger error"></span>
                                    </div>

                                    <div class="col-12">
                                        <button class="btn btn-primary" type="submit">Submit Form</button>
                                    </div>
                                </form>



                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>
    <script>
        $(document).ready(function () {
            // ✅ Initialize FilePond with existing image (if any)
            let existingImage = '<?= $gallery->gallery_image ?>';
            if (existingImage && !existingImage.startsWith('http')) {
                existingImage = '<?= base_url() ?>' + existingImage;
            }
            existingImage = existingImage.replace(/([^:]\/)\/+/g, "$1");

            const pond = FilePond.create(document.querySelector('.filepond-input-multiple'), {
                allowMultiple: false,
                maxFiles: 1,
                maxFileSize: '50MB',
                files: existingImage ? [{
                    source: existingImage,
                    options: { type: 'local' }
                }] : []
            });

            // ✅ Auto-sync Hindi category with English category by index
            $('select[name="gallery_category"]').on('change', function () {
                const selectedIndex = $(this).prop('selectedIndex');
                $('select[name="hindi_gallery_category"]').prop('selectedIndex', selectedIndex);
            });

            // ✅ Handle form submission via AJAX
            $("#galleryForm").on("submit", function (e) {
                e.preventDefault();
                $(".error").html("");

                const formData = new FormData(this);

                // ✅ Append FilePond file if selected
                if (pond.getFiles().length > 0) {
                    formData.append('gallery_image', pond.getFiles()[0].file);
                }

                $.ajax({
                    url: "<?= base_url('admin/gallery/update_gallery') ?>",
                    type: "POST",
                    data: formData,
                    contentType: false,
                    processData: false,
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, val) {
                                $("#error-" + key).html(val);
                            });
                        } else if (response.status === "success") {
                            window.location.href = response.redirect;
                        }
                    },
                    error: function (xhr) {
                        console.error("AJAX Error:", xhr.responseText);
                    }
                });
            });
        });
    </script>




</body>

</html>