<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Job Post | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Job Post</h4>
                    </div>

                    <div class="text-end">
                        <a href="<?= base_url('add-job-post') ?>" class="btn btn-soft-secondary">
                            Add Job Post &nbsp;
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title"> Job Post DataTable </h4>
                            </div>
                            <div class="card-body">
                                <table data-tables="basic" class="table table-striped dt-responsive align-middle mb-0">
                                    <thead class="thead-sm text-uppercase fs-xxs">
                                        <tr>
                                            <th>S No.</th>
                                            <th>Position Name</th>
                                            <th>Hindi Position Name</th>
                                            <th>Job Location</th>
                                            <th>Hindi Job Location</th>
                                            <th>Qualification</th>
                                            <th>Hindi Qualification</th>
                                            <th>Job Responsibility</th>
                                            <th>Hindi Job Responsibility</th>
                                            <th>action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1; ?>
                                        <?php foreach ($jobs as $data): ?>
                                            <tr>
                                                <td><?= $i++ ?></td>
                                                <td><?= $data->position_name ?></td>
                                                <td><?= $data->hindi_position_name ?></td>
                                                <td><?= $data->job_location ?></td>
                                                <td><?= $data->hindi_job_location ?></td>
                                                <td><?= $data->qualification ?></td>
                                                <td><?= $data->hindi_qualification ?></td>
                                                <td><?= $data->job_responsibility ?></td>
                                                <td><?= $data->hindi_job_responsibility ?></td>
                                                <td>
                                                    <div class="d-flex gap-1">
                                                        <?php if ($data->status == 'active'): ?>
                                                            <a href="<?= base_url('admin/job_post/set_status/' . $data->id) ?>"
                                                                class="btn btn-light btn-icon btn-sm rounded-circle"><i
                                                                    class="ti ti-eye fs-lg"></i></a>
                                                        <?php else: ?>
                                                            <a href="<?= base_url('admin/job_post/set_status/' . $data->id) ?>"
                                                                class="btn btn-danger btn-icon btn-sm rounded-circle"><i
                                                                    class="ti ti-eye-off fs-lg"></i></a>
                                                        <?php endif; ?>
                                                        <a href="<?= base_url('admin/job_post/edit_job_post/' . $data->id) ?>"
                                                            class="btn btn-light btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-edit fs-lg"></i></a>

                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php if ($this->session->flashdata('message')): ?>
                <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999">
                    <div id="flashToast" class="toast align-items-center text-bg-success border-0 shadow-lg mt-3"
                        role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body fw-semibold">
                                <?= $this->session->flashdata('message'); ?>
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                                aria-label="Close"></button>
                        </div>
                    </div>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        var toastEl = document.getElementById('flashToast');
                        var toast = new bootstrap.Toast(toastEl, { delay: 3000 });
                        toast.show();
                    });
                </script>
            <?php endif; ?>


            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>


</body>

</html>