<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <title>Teams | Maalav Milk Admin Dashboard</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <!-- Begin page -->
    <div class="wrapper">

        <?php include_once('common_page/sidebar.php'); ?>
        <?php include_once('common_page/header.php'); ?>

        <!-- ============================================================== -->
        <!-- Start Main Content -->
        <!-- ============================================================== -->

        <div class="content-page">
            <div class="container-fluid">
                <div class="page-title-head d-flex align-items-center">
                    <div class="flex-grow-1">
                        <h4 class="fs-xl fw-bold m-0">Teams</h4>
                    </div>

                    <div class="text-end d-flex gap-3">
                        <div class="status-button-container-one" data-section="board-of-directors">
                            <button class="btn btn-secondary" disabled>
                                Loading...
                            </button>
                        </div>
                        <div class="status-button-container-two" data-section="key-management">
                            <button class="btn btn-secondary" disabled>
                                Loading...
                            </button>
                        </div>
                        <a href="<?= base_url('add-team') ?>" class="btn btn-soft-secondary">
                            Add Team &nbsp;
                            <i class="fa-solid fa-arrow-right"></i>
                        </a>
                    </div>
                </div>


                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-header justify-content-between">
                                <h4 class="card-title"> Teams DataTable </h4>
                            </div>
                            <div class="card-body">
                                <table data-tables="basic" class="table table-striped dt-responsive align-middle mb-0">
                                    <thead class="thead-sm text-uppercase fs-xxs">
                                        <tr>
                                            <th>S. No.</th>
                                            <th>Image</th>
                                            <th>Team Category</th>
                                            <th>Name</th>
                                            <th>Designation</th>
                                            <th>Email</th>
                                            <th>Phone</th>
                                            <th>Date</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $i = 1; ?>
                                        <?php foreach ($team as $data): ?>
                                            <tr>
                                                <td><?= $i++ ?></td>
                                                <td>
                                                    <img src="<?= base_url() ?><?= $data->featured_image ?>"
                                                        alt="Peaple Image" width="50">
                                                </td>
                                                <td><?= $data->category ?></td>
                                                <td><?= $data->name ?></td>
                                                <td><?= $data->designation ?></td>
                                                <td><?= $data->email ?></td>
                                                <td><?= $data->phone ?></td>
                                                <td><?= $data->date ?></td>
                                                <td>
                                                    <div class="d-flex gap-1">
                                                        <a href="<?= base_url('admin/teams/edit_team/' . $data->id) ?>"
                                                            class="btn btn-light btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-edit fs-lg"></i></a>
                                                        <a href="<?= base_url('admin/teams/delete_team/' . $data->id) ?>"
                                                            data-table-delete-row
                                                            class="btn btn-danger btn-icon btn-sm rounded-circle"><i
                                                                class="ti ti-trash fs-lg"></i></a>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div> <!-- end card-body-->
                        </div> <!-- end card-->
                    </div>
                </div>



            </div>
            <!-- container -->

            <?php if ($this->session->flashdata('message')): ?>
                <div class="toast-container position-fixed top-0 end-0 p-3" style="z-index: 9999">
                    <div id="flashToast" class="toast align-items-center text-bg-success border-0 shadow-lg mt-3"
                        role="alert" aria-live="assertive" aria-atomic="true">
                        <div class="d-flex">
                            <div class="toast-body fw-semibold">
                                <?= $this->session->flashdata('message'); ?>
                            </div>
                            <button type="button" class="btn-close btn-close-white me-2 m-auto" data-bs-dismiss="toast"
                                aria-label="Close"></button>
                        </div>
                    </div>
                </div>

                <script>
                    document.addEventListener("DOMContentLoaded", function () {
                        var toastEl = document.getElementById('flashToast');
                        var toast = new bootstrap.Toast(toastEl, { delay: 3000 });
                        toast.show();
                    });
                </script>
            <?php endif; ?>

            <?php include_once('common_page/footer.php'); ?>


        </div>

        <!-- ============================================================== -->
        <!-- End of Main Content -->
        <!-- ============================================================== -->

    </div>
    <!-- END wrapper -->

    <?php include_once('common_page/script.php'); ?>

    <script>
        $(document).ready(function () {

            // --- AUTO APPLY CHECKSTATUS TO ALL CONTAINERS ---
            $('.status-button-container-one, .status-button-container-two').each(function () {
                var container = $(this);
                var sectionName = container.data('section');
                checkStatus(sectionName, container);  // <---- IMPORTANT FIX
            });

            // --- CHECK STATUS FUNCTION (SAME RAKH RAHA HU) ---
            function checkStatus(section_name, container) {
                $.ajax({
                    url: '<?php echo base_url("admin/section/check_status"); ?>',
                    type: 'POST',
                    data: {
                        section_name: section_name,
                        '<?php echo $this->security->get_csrf_token_name(); ?>': '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {

                            var label = section_name.replace(/-/g, " ").replace(/\b\w/g, c => c.toUpperCase());

                            var buttonHtml = '';

                            if (response.status == 'active') {
                                buttonHtml =
                                    '<a href="javascript:void(0)" class="btn btn-danger status-toggle" ' +
                                    'data-current="active" data-section="' + section_name + '">' +
                                    'Inactive (' + label + ')</a>';
                            } else {
                                buttonHtml =
                                    '<a href="javascript:void(0)" class="btn btn-success status-toggle" ' +
                                    'data-current="inactive" data-section="' + section_name + '">' +
                                    'Active (' + label + ')</a>';
                            }

                            container.html(buttonHtml);
                        }
                    },
                    error: function () {
                        container.html('<span class="text-danger">Error loading status</span>');
                    }
                });
            }

            // --- STATUS UPDATE (NO CHANGE) ---
            $(document).on('click', '.status-toggle', function () {
                var button = $(this);
                var currentStatus = button.data('current');
                var section_name = button.data('section');

                var newStatus = currentStatus == 'active' ? 'inactive' : 'active';

                button.prop('disabled', true);
                button.html('<i class="fa fa-spinner fa-spin"></i> Updating...');

                $.ajax({
                    url: '<?php echo base_url("admin/section/update_status"); ?>',
                    type: 'POST',
                    data: {
                        section_name: section_name,
                        status: newStatus,
                        '<?php echo $this->security->get_csrf_token_name(); ?>':
                            '<?php echo $this->security->get_csrf_hash(); ?>'
                    },
                    dataType: 'json',
                    success: function (response) {
                        if (response.success) {

                            var label = section_name.replace(/-/g, " ").replace(/\b\w/g, c => c.toUpperCase());

                            if (newStatus == 'active') {
                                button.removeClass('btn-success').addClass('btn-danger')
                                    .text('Inactive (' + label + ')')
                                    .data('current', 'active');
                            } else {
                                button.removeClass('btn-danger').addClass('btn-success')
                                    .text('Active (' + label + ')')
                                    .data('current', 'inactive');
                            }

                            alert('Status successfully updated to ' + newStatus + '!');
                        } else {
                            alert('Error: ' + response.message);
                            checkStatus(section_name);
                        }
                    },
                    error: function () {
                        alert('Ajax error!');
                        checkStatus(section_name);
                    },
                    complete: function () {
                        button.prop('disabled', false);
                    }
                });
            });

        });
    </script>

</body>

</html>