<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'पुरस्कार और मान्यता | मालव दूध' : 'Awards & Recognition | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'पुरस्कार और मान्यता' : 'Awards & Recognition' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a>
                        </li>
                        <li><?= $language == 'hi' ? 'पुरस्कार और मान्यता' : 'Awards & Recognition' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->

            <section class="mb-5">
                <div class="container">
                    <div class="section-title-center v1">
                        <h3><?= $language == 'hi' ? 'पुरस्कार और मान्यता' : 'Awards & Recognition' ?></h3>
                    </div>
                    <div class="mt-3 mb-5 text-center">
                        <?php foreach ($award as $data): ?>
                            <div class="mb-5">
                                <h4>
                                    <?= $language == 'hi' ? $data->hindi_title : $data->title ?>
                                </h4>
                                <div class="row mt-3">
                                    <img src="<?= base_url($data->featured_image_one) ?>" class="col-6" alt="award image">
                                    <img src="<?= base_url($data->featured_image_two) ?>" class="col-6" alt="award image">
                                </div>
                            </div>
                        <?php endforeach; ?>

                    </div>
                </div>
            </section>
        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>