<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk blog page" />
    <meta name="description" content="Maalav Milk - Maalav Milk blog page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'ब्लॉग | मालव दूध' : ' Blogs | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'ब्लॉग' : 'Blog' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'ब्लॉग' : 'Blog' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Blog Start -->
            <section class="blog v1 pb-xl-spach">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-8">
                            <?php if ($blogs): ?>
                                <?php foreach ($blogs as $data): ?>
                                    <div class="big-post">
                                        <div class="post-img">
                                            <a href="<?= base_url('blog/' . $data->slug) ?>">
                                                <img src="<?= base_url($data->featured_image) ?>" alt="post">
                                            </a>
                                        </div>
                                        <div class="post-content">
                                            <ul>
                                                <li>
                                                    <h6>
                                                        <span class="my-icon icon-user"></span>
                                                        <?= $language == 'hi' ? $data->hindi_author : $data->author ?>
                                                    </h6>
                                                </li>
                                                <li>
                                                    <h6>
                                                        <span class="my-icon icon-clock"></span>
                                                        <?= date('d M Y', strtotime($data->date ?? date('Y-m-d'))) ?>
                                                    </h6>
                                                </li>

                                            </ul>
                                            <h3>
                                                <a href="<?= base_url('blog/' . $data->slug) ?>">
                                                    <?= $language == 'hi' ? $data->hindi_title : $data->title; ?>

                                                </a>
                                            </h3>
                                            <p> <?= word_limiter(strip_tags($language == "hi" ? $data->hindi_content : $data->content), 50) ?>
                                            </p>
                                            <a class="post-link"
                                                href="<?= base_url('blog/' . $data->slug) ?>"><?= $language == 'hi' ? 'और पढ़ें' : 'read more' ?></a>
                                        </div>
                                    </div>
                                <?php endforeach ?>
                            <?php else: ?>
                                <p>No blogs found.</p>
                            <?php endif; ?>

                        </div>
                        <div class="col-lg-4">
                            <div class="blog-sidebar__wrapper" style="position: sticky; top: 100px;">
                                <div class="blog-sidebar__widget">
                                    <div class="blog-sidebar__widget-head">
                                        <h4 class="blog-sidebar__widget-title">
                                            <?= $language == 'hi' ? 'केटेगरी' : 'Category' ?>
                                        </h4>
                                    </div>
                                    <div class="blog-sidebar__widget-content">
                                        <div class="category-list">
                                            <ul>
                                                <?php foreach ($category as $data): ?>
                                                    <li>
                                                        <h6>
                                                            <a href="<?= base_url('news/' . $data->category) ?>">
                                                                <?= $language == 'hi' ? $data->hindi_category : $data->category ?>
                                                            </a>
                                                        </h6>
                                                    </li>
                                                <?php endforeach; ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="blog-sidebar__widget">
                                    <div class="blog-sidebar__widget-head">
                                        <h4 class="blog-sidebar__widget-title">
                                            <?= $language == 'hi' ? 'फॉलो करे' : 'Follow Us' ?>
                                        </h4>
                                    </div>
                                    <div class="blog-sidebar__widget-content">
                                        <div class="socials-links-box">
                                            <ul>
                                                <li><a href="#"><span class="my-icon icon-facebook"></span></a></li>
                                                <li><a href="#"><span class="my-icon icon-twitter"></span></a></li>
                                                <li><a href="#"><span class="my-icon icon-linkedin-in"></span></a></li>
                                                <li><a href="#"><span class="my-icon icon-instagram"></span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Blog End -->
        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>