<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title><?= $language == 'hi' ? 'हमारे बारे में | मालव दूध' : 'About Us | Maalav Milk' ?></title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2> <?= $language == 'hi' ? 'चेयरमैन नोट' : 'Chairman Note' ?> </h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'चेयरमैन नोट' : 'Chairman Note' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- About Beeberry Start -->

            <section class="" id="chairman-note">
                <div class="container">
                    <div class="section-title-center v1">
                        <h6><?= $language == 'hi' ? 'चेयरमैन नोट' : 'Chairman Note' ?></h6>
                    </div>
                    <?php foreach ($note as $data): ?>
                        <div>
                            <img src="<?= base_url($data->featured_image) ?>" alt="chairman image" width="200">
                            <br />
                            <br />
                            <?= $language == 'hi' ? $data->hindi_content : $data->content ?>
                        </div>
                    <?php endforeach; ?>
                </div>
            </section>

        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>

    <?php include_once('common_page/script.php'); ?>
</body>

</html>