<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'हमारा विशेष कार्य, हमारा नज़रिया, हमारे मूल्य | मालव दूध' : 'Mission, Vision, Value | Maalav Milk' ?>
    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>
    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2> <?= $language == 'hi' ? 'हमारा विशेष कार्य, हमारा नज़रिया, हमारे मूल्य' : 'Mission, Vision, Value' ?>
                    </h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'हमारा विशेष कार्य, हमारा नज़रिया, हमारे मूल्य' : 'Mission, Vision, Value' ?>
                        </li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Team Start -->
            <section class="our-services v1" id="value-mission-vision">
                <div class="container my-5">

                    <h2 class="text-center mb-5 fw-bold">
                        <?= $language == 'hi' ? 'बाकियों से अलग दिखें' : 'Stand Out From The Rest' ?>
                    </h2>

                    <div class="row g-4 align-items-stretch">

                        <!-- IMAGE LEFT -->
                        <div class="col-md-4">
                            <div>
                                <img src="<?= base_url('assets/img/mission1.jpeg') ?>"
                                    class="img-fluid rounded-4 w-100 h-80 object-fit-cover" alt="">
                            </div>

                            <div class="mt-2">
                                <div class="p-4 bg-light rounded-4 text-center shadow-sm d-flex flex-column h-100">
                                    <div class="mb-3">
                                        <img src="<?= base_url('assets/img/vision.png') ?>" width="80">
                                    </div>
                                    <h4 class="fw-bold mb-3">
                                        <?= $language == 'hi' ? 'हमारा नज़रिया' : 'Our Vision' ?>
                                    </h4>
                                    <p class="flex-grow-1">
                                        <?= $language == 'hi' ? 'मालव मिल्क प्रोड्यूसर कंपनी लिमिटेड देश के शीर्ष 10 डेयरी
                                    उद्यमों में से एक होगी।' : 'Maalav Milk Producer Company Limited will be among the top 10 Dairy
									Enterprises in the country.' ?>

                                    </p>
                                </div>
                            </div>
                        </div>

                        <!-- VALUES -->
                        <div class="col-md-4">
                            <div class="p-4 bg-light rounded-4 text-center shadow-sm d-flex flex-column">
                                <div class="mb-3">
                                    <img src="<?= base_url('assets/img/value.png') ?>" width="80">
                                </div>
                                <h4 class="fw-bold mb-3">
                                    <?= $language == 'hi' ? 'हमारे मूल्य' : 'Our Values' ?>

                                </h4>
                                <ul class="text-start mx-auto flex-grow-1" style="max-width: 260px;">
                                    <li>
                                        <?= $language == 'hi' ? 'पारदर्शिता' : 'Transparency' ?>

                                    </li>
                                    <li>
                                        <?= $language == 'hi' ? 'हर पहलू में गुणवत्ता' : 'Quality in every aspect' ?>

                                    </li>
                                    <li>
                                        <?= $language == 'hi' ? 'नवाचार' : 'Innovation' ?>

                                    </li>
                                    <li>
                                        <?= $language == 'hi' ? 'ईमानदारी और जवाबदेही' : 'Honesty & Accountability' ?>

                                    </li>
                                    <li>
                                        <?= $language == 'hi' ? 'भरोसा और टीम वर्क' : 'Trust & Team Work' ?>

                                    </li>
                                    <li>
                                        <?= $language == 'hi' ? 'उत्कृष्टता के लिए जुनून' : 'Passion for Excellence' ?>

                                    </li>
                                    <li>
                                        <?= $language == 'hi' ? 'लक्ष्य प्रेरित' : 'Goal Driven' ?>

                                    </li>
                                </ul>
                                 <div class="mt-5">
                                    <a href="<?= base_url() ?>" class="btn btn-primary text-white fw-bold">HOME</a>
                                </div>
                            </div>
                        </div>

                        <!-- MISSION -->
                        <div class="col-md-4">
                            <div class="p-4 bg-light rounded-4 text-center shadow-sm d-flex flex-column">
                                <div class="mb-3">
                                    <img src="<?= base_url('assets/img/mission.png') ?>" width="80">
                                </div>
                                <h4 class="fw-bold mb-3">
                                    <?= $language == 'hi' ? 'हमारा विशेष कार्य' : 'Our Mission' ?>

                                </h4>
                                <p class="flex-grow-1">
                                    <?= $language == 'hi' ? 'हम अपने सदस्यों को आपूर्ति किए गए दूध और सेवाओं के लिए प्रतिस्पर्धी मूल्य प्रदान करके उन्हें लाभान्वित करने के लिए प्रतिबद्ध हैं।' : 'We are committed to benefiting our members by providing them a competitive price
									for the milk supplied and services.' ?>

                                </p>
                            </div>
                            <div class="mt-2">
                                <img src="<?= base_url('assets/img/mission2.jpeg') ?>"
                                    class="img-fluid rounded-4 w-100 h-100 object-fit-cover" alt="">
                            </div>
                        </div>

                        <!-- VISION -->


                        <!-- IMAGE RIGHT -->


                    </div>
                </div>
            </section>
        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>