<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk blog page" />
    <meta name="description" content="Maalav Milk - Maalav Milk blog page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>News And Event Details | Maalav Milk</title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>

        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2>News And Event Details</h2>
                    <ul>
                        <li><a href="<?= base_url() ?>">Home</a></li>
                        <li>News And Event Details</li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!--  Blog Details Start -->
            <section class="blog-details v1 pb-xl-spach">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-8">
                            <div class="big-post-details">
                                <div class="post-img">
                                    <a href="<?= base_url('blog/' . $details->slug) ?>">
                                        <img src="<?= base_url($details->featured_image) ?>" alt="post">
                                    </a>
                                </div>
                                <div class="post-content">
                                    <ul>

                                        <li>
                                            <h6>
                                                <span class="my-icon icon-clock"></span>
                                                <?= date('d M Y', strtotime($details->date ?? date('Y-m-d'))) ?>
                                            </h6>
                                        </li>

                                    </ul>
                                    <h3><?= $language == 'hi' ? $details->hindi_title : $details->title ?></h3>
                                    <?= $language == 'hi' ? $details->hindi_content : $details->content ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-4">
                            <div class="blog-sidebar__wrapper" style="position: sticky; top: 100px;">


                                <div class="blog-sidebar__widget">
                                    <div class="blog-sidebar__widget-head">
                                        <h4 class="blog-sidebar__widget-title">
                                            <?= $language == 'hi' ? 'लेटेस्ट पोस्ट्स' : 'Latest Posts' ?>
                                        </h4>
                                    </div>
                                    <div class="blog-sidebar__widget-content">
                                        <div class="latest-posts">
                                            <ul>

                                                <?php
                                                $counter = 0;
                                                foreach ($news as $datas):
                                                    if ($counter++ >= 3)
                                                        break; // sirf 3 records hi dikhao
                                                    ?>
                                                    <?php if ($datas->category == $details->category): ?>
                                                        <li>
                                                            <div class="post-img">
                                                                <img src="<?= base_url($datas->featured_image) ?>" alt="post"
                                                                    width="100">
                                                            </div>
                                                            <div class="post-text">
                                                                <h6>
                                                                    <a href="<?= base_url('blog/' . $datas->slug) ?>">
                                                                        <?= $language == 'hi' ? $datas->hindi_title : $datas->title ?>
                                                                    </a>
                                                                </h6>
                                                                <p>
                                                                    <span class="my-icon icon-clock"></span>
                                                                    <?= date('d M Y', strtotime($datas->date ?? date('Y-m-d'))) ?>
                                                                </p>
                                                            </div>
                                                        </li>

                                                    <?php endif; ?>
                                                <?php endforeach; ?>

                                            </ul>
                                        </div>
                                    </div>
                                </div>

                                <div class="blog-sidebar__widget">
                                    <div class="blog-sidebar__widget-head">
                                        <h4 class="blog-sidebar__widget-title">
                                            <?= $language ? 'फॉलो करे' : 'Follow Us' ?>
                                        </h4>
                                    </div>
                                    <div class="blog-sidebar__widget-content">
                                        <div class="socials-links-box">
                                            <ul>
                                                <li><a href="#"><span class="my-icon icon-facebook"></span></a></li>
                                                <li><a href="#"><span class="my-icon icon-twitter"></span></a></li>
                                                <li><a href="#"><span class="my-icon icon-linkedin-in"></span></a></li>
                                                <li><a href="#"><span class="my-icon icon-instagram"></span></a></li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!--  Blog Details End -->
        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>