<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi'
            ? $details->hindi_service_name . ' | मालव दूध'
            : $details->service_name . ' | Maalav Milk'
            ?>
    </title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? $details->hindi_service_name : $details->service_name ?>
                    </h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? $details->hindi_service_name : $details->service_name ?> </li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Our Services Start -->
            <section class="our-services v2">
                <div class="container">
                    <div class="row mb-5">
                        <div class="col-lg-6 col-xl-5 order-lg-1">
                            <div class="right-content">
                                <div class="check-our-profile">
                                    <img src="<?= base_url($details->featured_image_one) ?>" alt="profile-img">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-xl-7">
                            <div class="content-left">
                                <div class="section-title v1">
                                    <h6><?= $language == 'hi' ? 'हमारी सेवाएँ' : 'Our Services' ?></h6>
                                    <h3><?= $language == 'hi' ? $details->hindi_title_one : $details->title_one ?></h3>
                                </div>
                                <div>
                                    <?= $language == 'hi' ? $details->hindi_content_one : $details->content_one ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-5">
                        <div class="col-lg-6 col-xl-5">
                            <div class="right-content">
                                <div class="check-our-profile">
                                    <img src="<?= base_url($details->featured_image_two) ?>" alt="profile-img">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-xl-7">
                            <div class="content-left">
                                <div class="section-title v1">

                                    <h3><?= $language == 'hi' ? $details->hindi_title_two : $details->title_two ?></h3>
                                </div>
                                <div>
                                     <?= $language == 'hi' ? $details->hindi_content_two : $details->content_two ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mb-5">
                        <div class="col-lg-6 col-xl-5 order-lg-1">
                            <div class="right-content">
                                <div class="check-our-profile">
                                    <img src="<?= base_url($details->featured_image_three) ?>" alt="profile-img">
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6 col-xl-7">
                            <div class="content-left">
                                <div class="section-title v1">

                                    <h3><?= $language == 'hi' ? $details->hindi_title_three : $details->title_three ?>
                                    </h3>
                                </div>
                                <div>
                                    <?= $language == 'hi' ? $details->hindi_content_three : $details->content_three ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <!-- Our Services End -->

        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>