<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title>
        <?= $language == 'hi' ? 'टीम मेंबर्स | मालव दूध' : 'Team Members | Maalav Milk' ?>

    </title>
    <?php include_once('common_page/links.php'); ?>
    <style>
        .team-area {
            padding: 60px 0;
        }

        a,
        a:hover,
        a:focus,
        a:active {
            text-decoration: none;
            outline: none;
        }

        ul {
            margin: 0;
            padding: 0;
            list-style: none;
        }

        .site-heading h2 {
            display: block;
            font-weight: 700;
            margin-bottom: 10px;
            text-transform: uppercase;
        }

        .site-heading h2 span {
            color: #ff5a6e;
        }

        .site-heading h4 {
            display: inline-block;
            padding-bottom: 20px;
            position: relative;
            text-transform: capitalize;
            z-index: 1;
        }

        .site-heading h4::before {
            background: #ff5a6e none repeat scroll 0 0;
            bottom: 0;
            content: "";
            height: 2px;
            left: 50%;
            margin-left: -25px;
            position: absolute;
            width: 50px;
        }

        .site-heading h2 span {
            color: #ff5a6e;
        }

        .site-heading {
            margin-bottom: 60px;
            overflow: hidden;
            margin-top: -5px;
        }

        .team-area .single-item {
            margin-bottom: 30px;
        }

        .team-area .item .thumb {
            position: relative;
            overflow: hidden;
            z-index: 1;
        }

        .team-area .item .thumb::after {
            background: #232323 none repeat scroll 0 0;
            content: "";
            height: 100%;
            left: 0;
            opacity: 0;
            position: absolute;
            top: 0;
            transition: all 0.35s ease-in-out;
            -webkit-transition: all 0.35s ease-in-out;
            -moz-transition: all 0.35s ease-in-out;
            -ms-transition: all 0.35s ease-in-out;
            -o-transition: all 0.35s ease-in-out;
            width: 100%;
        }

        .team-area .team-items .item:hover .thumb::after {
            opacity: 0.7;
        }

        .team-area .item .thumb .overlay {
            top: -100%;
            left: 0;
            padding: 20px;
            position: absolute;
            text-align: center;
            -webkit-transition: all 0.35s ease-in-out;
            -moz-transition: all 0.35s ease-in-out;
            -ms-transition: all 0.35s ease-in-out;
            -o-transition: all 0.35s ease-in-out;
            transition: all 0.35s ease-in-out;
            width: 100%;
            z-index: 1;
        }

        .team-area .item:hover .thumb .overlay {
            top: 50%;
            transform: translate(-50%, -50%);
            left: 50%;
        }

        .team-area .item .thumb .overlay p {
            color: #ffffff;
        }

        .team-area .item .thumb .overlay h4 {
            color: #ffffff;
            display: inline-block;
            position: relative;
            text-transform: uppercase;
        }

        .team-area .item .thumb img {
            -webkit-transition: all 0.35s ease-in-out;
            -moz-transition: all 0.35s ease-in-out;
            -ms-transition: all 0.35s ease-in-out;
            -o-transition: all 0.35s ease-in-out;
            transition: all 0.35s ease-in-out;
        }

        .team-area .item:hover .thumb img {
            opacity: 0.6;
        }

        .team-area .item .thumb .social li {
            display: inline-block;
        }

        .team-area .item .thumb .social li a {
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
            border-radius: 50%;
            color: #ffffff;
            display: inline-block;
            height: 40px;
            line-height: 40px;
            margin: 0 2px;
            text-align: center;
            width: 40px;
        }

        .team-area .info {
            background: #ffffff none repeat scroll 0 0;
            -moz-box-shadow: 0 0 10px #cccccc;
            -webkit-box-shadow: 0 0 10px #cccccc;
            -o-box-shadow: 0 0 10px #cccccc;
            box-shadow: 0 0 10px #cccccc;
            padding: 40px 20px 20px;
            position: relative;
            text-align: center;
            z-index: 0;
        }

        .team-area .info .message {
            height: 50px;
            line-height: 40px;
            margin-left: -25px;
            margin-top: -25px;
            position: absolute;
            text-align: center;
            top: 0;
            width: 50px;
        }

        .team-area .info .message a {
            background: #fff none repeat scroll 0 0;
            -webkit-border-radius: 50%;
            -moz-border-radius: 50%;
            border-radius: 50%;
            -moz-box-shadow: 0 0 10px #cccccc;
            -webkit-box-shadow: 0 0 10px #cccccc;
            -o-box-shadow: 0 0 10px #cccccc;
            box-shadow: 0 0 10px #cccccc;
            box-sizing: border-box;
            color: #ff5a6e;
            display: inline-block;
            font-size: 20px;
            height: 50px;
            line-height: 50px;
            width: 50px;
        }

        .team-area .info .message a i {
            font-weight: 500;
        }

        .team-area .info h4 {
            font-weight: 600;
            margin-bottom: 5px;
            text-transform: capitalize;
        }

        .team-area .info span {
            color: #ff5a6e;
            font-family: "Poppins", sans-serif;
            font-weight: 600;
            text-transform: uppercase;
        }

        .team-area .social li.twitter a {
            background-color: #00b6f1;
        }

        .team-area .social li.pinterest a {
            background-color: #bd081c;
        }

        .team-area .social li.facebook a {
            background-color: #3b5998;
        }

        .team-area .social li.google-plus a {
            background-color: #df4a32;
        }

        .team-area .social li.vimeo a {
            background-color: #1ab7ea;
        }

        .team-area .social li.instagram a {
            background-color: #cd486b;
        }
    </style>
</head>

<body>
    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>
        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2> <?= $language == 'hi' ? 'टीम मेंबर्स' : 'Team Members' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'टीम मेंबर्स' : 'Team Members' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <section id="team" class="team-area">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="site-heading text-center">
                                <h2><?= $language == 'hi' ? 'बोर्ड ऑफ़ डायरेक्टर्स' : 'Board of Directors' ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="row team-items">
                        <?php foreach ($team as $data): ?>
                            <?php if ($data->category == 'Board of Directors'): ?>
                                <div class="col-md-3 single-item">
                                    <div class="item">
                                       
                                            <div class="thumb">
                                                <img class="img-fluid" src="<?= base_url($data->featured_image) ?>"
                                                    alt="Thumb" />

                                            </div>
                                      

                                        <div class="info">

                                            <h4>
                                                <?= $language == 'hi' ? $data->hindi_name : $data->name ?>
                                                
                                            </h4>
                                            <span><?= $language == 'hi' ? $data->hindi_designation : $data->designation ?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>
            <section id="team" class="team-area mb-5">
                <div class="container">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="site-heading text-center">
                                <h2><?= $language == 'hi' ? 'की मैनेजमेंट' : 'Key Management' ?></h2>
                            </div>
                        </div>
                    </div>
                    <div class="row team-items">
                        <?php foreach ($team as $data): ?>
                            <?php if ($data->category == 'Key Management'): ?>
                                <div class="col-md-3 single-item">
                                    <div class="item">
                                        
                                            <div class="thumb">
                                                <img class="img-fluid" src="<?= base_url($data->featured_image) ?>"
                                                    alt="Thumb" />

                                            </div>
                                       

                                        <div class="info">

                                            <h4>
                                                <?= $language == 'hi' ? $data->hindi_name : $data->name ?>
                                            </h4>
                                            <span><?= $language == 'hi' ? $data->hindi_designation : $data->designation ?></span>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    </div>
                </div>
            </section>

        </main>
        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>
</body>

</html>