<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title><?= $language == 'hi' ? 'टर्म्स एंड कंडीशंस | मालव दूध' : 'Terms And Conditions | Maalav Milk' ?></title>

    <?php include_once('common_page/links.php'); ?>

    <style>
        .hero {
            background: linear-gradient(90deg, #e6f0ff, #ffffff);
            border-radius: 0.5rem;
        }

        .toc a {
            text-decoration: none;
        }

        .section {
            padding-top: 1.25rem;
            padding-bottom: 1.25rem;
        }

        .small-muted {
            font-size: 0.9rem;
            color: #6c757d;
        }

        section[id] {
            scroll-margin-top: 7rem;
            /* same as your sticky top */
        }

        .sticky-top {
            z-index: 1;
        }

        @media (max-width: 991px) {
            .sticky-top {
                position: static !important;
                top: auto !important;
            }
        }
    </style>
</head>

<body>
    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>

        <main>
            <!-- Breadcrumb Start -->
            <section class="breadcum v1 bg-cover-center" data-background="assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'टर्म्स एंड कंडीशंस' : 'Terms And Conditions' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'टर्म्स एंड कंडीशंस' : 'Terms And Conditions' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcrumb End -->

            <section class="container my-5 mb-5">
                <div class="row">
                    <!-- Sidebar / Table of Contents -->
                    <aside class="col-lg-4 mb-4">
                        <div class="card sticky-top" style="top: 7rem;">
                            <div class="card-body">
                                <h5 class="card-title mb-3"><?= $language == 'hi' ? 'सामग्री' : 'Contents' ?></h5>
                                <nav class="toc">
                                    <ul class="list-unstyled">
                                        <li><a
                                                href="#introduction"><?= $language == 'hi' ? 'परिचय' : 'Introduction' ?></a>
                                        </li>
                                        <li><a
                                                href="#acceptance"><?= $language == 'hi' ? 'शर्तों को स्वीकार करना' : 'Acceptance' ?></a>
                                        </li>
                                        <li><a
                                                href="#use"><?= $language == 'hi' ? 'वेबसाइट का उपयोग' : 'Use of Website' ?></a>
                                        </li>
                                        <li><a
                                                href="#orders"><?= $language == 'hi' ? 'ऑर्डर और भुगतान' : 'Orders & Payments' ?></a>
                                        </li>
                                        <li><a
                                                href="#delivery"><?= $language == 'hi' ? 'वितरण नीति' : 'Delivery Policy' ?></a>
                                        </li>
                                        <li><a
                                                href="#returns"><?= $language == 'hi' ? 'रिटर्न और रिफंड नीति' : 'Return & Refund Policy' ?></a>
                                        </li>
                                        <li><a
                                                href="#prohibited"><?= $language == 'hi' ? 'प्रतिबंधित उपयोग' : 'Prohibited Uses' ?></a>
                                        </li>
                                        <li><a
                                                href="#liability"><?= $language == 'hi' ? 'दायित्व की सीमा' : 'Limitation of Liability' ?></a>
                                        </li>
                                        <li><a
                                                href="#privacy"><?= $language == 'hi' ? 'गोपनीयता नीति' : 'Privacy Policy' ?></a>
                                        </li>
                                        <li><a
                                                href="#changes"><?= $language == 'hi' ? 'शर्तों में बदलाव' : 'Changes to Terms' ?></a>
                                        </li>
                                        <li><a href="#contact"><?= $language == 'hi' ? 'संपर्क करें' : 'Contact' ?></a>
                                        </li>
                                    </ul>
                                </nav>
                            </div>
                        </div>
                    </aside>

                    <!-- Main Article -->
                    <article class="col-lg-8">
                        <!-- Sections -->
                        <section id="introduction" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>1. <?= $language == 'hi' ? 'परिचय' : 'Introduction' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'मालव दूध में आपका स्वागत है ("हम", "हमारा")। हमारी वेबसाइट का उपयोग करके आप इन शर्तों और नियमों का पालन करने के लिए सहमत हैं।' : 'Welcome to Maalav Milk ("we", "our"). By using our website, you agree to comply with and be bound by these Terms and Conditions.' ?>
                            </p>
                        </section>

                        <section id="acceptance" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>2. <?= $language == 'hi' ? 'शर्तों को स्वीकार करना' : 'Acceptance of Terms' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हमारी वेबसाइट का उपयोग करने या खरीदारी करने का मतलब है कि आप इन शर्तों को स्वीकार करते हैं। यदि आप सहमत नहीं हैं, तो कृपया हमारी सेवाओं का उपयोग न करें।' : 'By using our website or making a purchase, you accept these Terms. If you do not agree, please do not use our services.' ?>
                            </p>
                        </section>

                        <section id="use" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>3. <?= $language == 'hi' ? 'वेबसाइट का उपयोग' : 'Use of Website' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'आप हमारी वेबसाइट का उपयोग केवल कानूनी उद्देश्यों के लिए करेंगे। आप किसी भी सामग्री को पोस्ट या प्रसारित नहीं करेंगे जो कानून का उल्लंघन करती हो, अधिकारों का हनन करती हो, या हानिकारक सॉफ़्टवेयर/स्क्रिप्ट्स शामिल करती हो।' : 'You agree to use the Maalav Milk website for lawful purposes only. You shall not post or transmit any material that violates laws, infringes rights, or contains harmful software or scripts.' ?>
                            </p>
                        </section>

                        <section id="orders" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>4. <?= $language == 'hi' ? 'ऑर्डर और भुगतान' : 'Orders & Payments' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हमारी वेबसाइट पर किए गए सभी ऑर्डर उत्पाद की उपलब्धता और कीमत की पुष्टि के अधीन हैं। हम किसी भी समय किसी ऑर्डर को अस्वीकार या रद्द करने का अधिकार सुरक्षित रखते हैं।' : 'All product orders are subject to availability and confirmation of price. We reserve the right to refuse or cancel any order at any time.' ?>
                            </p>
                            <ul>
                                <li><?= $language == 'hi' ? 'सभी कीमतों में लागू कर शामिल हैं।' : 'All prices include applicable taxes.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'भुगतान UPI, क्रेडिट/डेबिट कार्ड या अन्य उपलब्ध तरीकों से किया जा सकता है।' : 'Payments can be made via UPI, credit/debit cards, or other available methods.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'एक बार ऑर्डर पुष्टि होने के बाद, इसे प्रक्रिया शुरू होने के बाद संशोधित या रद्द नहीं किया जा सकता।' : 'Once an order is confirmed, it cannot be modified or canceled after processing.' ?>
                                </li>
                            </ul>
                        </section>

                        <section id="delivery" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>5. <?= $language == 'hi' ? 'वितरण नीति' : 'Delivery Policy' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'मालव दूध यह सुनिश्चित करता है कि ताज़ा और उच्च गुणवत्ता वाले उत्पाद समय पर वितरित किए जाएं। वितरण समय स्थान, मौसम या अन्य अनपेक्षित परिस्थितियों के अनुसार भिन्न हो सकता है।' : 'Maalav Milk ensures fresh and high-quality products are delivered on time. Delivery timelines may vary based on location, weather, or unforeseen circumstances.' ?>
                            </p>
                            <p>
                                <?= $language == 'hi' ? 'हम गलत पते या प्राप्तकर्ता की अनुपलब्धता के कारण हुई देरी के लिए जिम्मेदार नहीं हैं।' : 'We are not responsible for delays caused by incorrect address or recipient unavailability.' ?>
                            </p>
                        </section>

                        <section id="returns" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>6. <?= $language == 'hi' ? 'रिटर्न और रिफंड नीति' : 'Return & Refund Policy' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'चूँकि डेयरी उत्पाद नाशवान होते हैं, डिलीवरी के बाद आमतौर पर रिटर्न स्वीकार नहीं किए जाते। केवल उत्पाद क्षति या गलत डिलीवरी के मामले में रिफंड दिया जा सकता है।' : 'As dairy products are perishable, returns are generally not accepted after delivery. Refunds may be issued only in case of product damage or incorrect delivery.' ?>
                            </p>
                            <p>
                                <?= $language == 'hi' ? 'ग्राहक को किसी भी समस्या की रिपोर्ट डिलीवरी के <strong>24 घंटों</strong> के भीतर भेजनी होगी।' : 'Customers must report any issue within <strong>24 hours</strong> of delivery.' ?>
                            </p>
                        </section>

                        <section id="prohibited" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>7. <?= $language == 'hi' ? 'प्रतिबंधित उपयोग' : 'Prohibited Uses' ?></h2>
                            <ul>
                                <li><?= $language == 'hi' ? 'कानूनी उद्देश्यों के लिए उपयोग न करना।' : 'Using the website for unlawful purposes.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'वायरस या हानिकारक कोड अपलोड करना।' : 'Uploading viruses or malicious code.' ?>
                                </li>
                                <li><?= $language == 'hi' ? 'अनुमति के बिना अन्य उपयोगकर्ताओं का व्यक्तिगत डेटा इकट्ठा करना।' : 'Collecting personal data of others without consent.' ?>
                                </li>
                            </ul>
                        </section>

                        <section id="liability" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>8. <?= $language == 'hi' ? 'दायित्व की सीमा' : 'Limitation of Liability' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'मालव दूध किसी भी अप्रत्यक्ष, आकस्मिक, या परिणामस्वरूप होने वाले नुकसान के लिए उत्तरदायी नहीं होगा।' : 'Maalav Milk will not be liable for any indirect, incidental, or consequential damages.' ?>
                            </p>
                            <p>
                                <?= $language == 'hi' ? 'हम उत्पाद की जानकारी सही बनाने का प्रयास करते हैं लेकिन रंग, विवरण या चित्रों में त्रुटि की गारंटी नहीं देते।' : 'We make every effort to ensure accurate product information but do not guarantee descriptions, colors, or images are error-free.' ?>
                            </p>
                        </section>

                        <section id="privacy" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>9. <?= $language == 'hi' ? 'गोपनीयता नीति' : 'Privacy Policy' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हम आपकी गोपनीयता का सम्मान करते हैं और आपके व्यक्तिगत डेटा की सुरक्षा के लिए प्रतिबद्ध हैं।' : 'We respect your privacy and are committed to protecting your personal information.' ?>
                                <a href="https://www.maalavmilk.com/privacy-policy"
                                    target="_blank"><?= $language == 'hi' ? 'गोपनीयता नीति देखें।' : 'See our Privacy Policy.' ?></a>
                            </p>
                        </section>

                        <section id="changes" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>10. <?= $language == 'hi' ? 'शर्तों में बदलाव' : 'Changes to Terms' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'हम किसी भी समय इन शर्तों को अपडेट या संशोधित करने का अधिकार सुरक्षित रखते हैं। अपडेटेड शर्तें इस पेज पर प्रकाशित की जाएंगी।' : 'We reserve the right to update or modify these Terms at any time. Updated Terms will be posted on this page.' ?>
                            </p>
                        </section>

                        <section id="contact" class="section bg-white p-4 rounded shadow-sm mb-3">
                            <h2>11. <?= $language == 'hi' ? 'संपर्क करें' : 'Contact Us' ?></h2>
                            <p>
                                <?= $language == 'hi' ? 'इन शर्तों के बारे में किसी भी प्रश्न के लिए, कृपया हमसे संपर्क करें:' : 'For any questions about these Terms, please contact us:' ?>
                            </p>
                            <p class="mb-0"><strong>Email:</strong> <a
                                    href="mailto:support@maalavmilk.com">support@maalavmilk.com</a></p>
                            <p class="mb-0"><strong>Website:</strong> <a href="https://www.maalavmilk.com/"
                                    target="_blank">www.maalavmilk.com</a></p>
                            <p class="mb-0"><strong>Address:</strong> Maalav Milk Pvt. Ltd., India</p>
                        </section>

                    </article>
                </div>
            </section>
        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>

    <?php include_once('common_page/script.php'); ?>

    <script>
        // Smooth scroll for table of contents
        document.querySelectorAll(".toc a").forEach((a) => {
            a.addEventListener("click", function (e) {
                e.preventDefault();
                const target = document.querySelector(this.getAttribute("href"));
                if (target) target.scrollIntoView({ behavior: "smooth", block: "start" });
            });
        });
    </script>
</body>

</html>