<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8" />
    <meta name="keywords" content="Maalav Milk - Maalav Milk home page" />
    <meta name="description" content="Maalav Milk - Maalav Milk home page" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />

    <title><?= $language == 'hi' ? 'विक्रेता पूछताछ | मालव दूध' : 'Vendor Enquriy | Maalav Milk' ?></title>
    <?php include_once('common_page/links.php'); ?>
</head>

<body>


    <div id="main-wrapper">
        <?php include_once('common_page/header.php'); ?>

        <main>
            <!-- Breadcum Start -->
            <section class="breadcum v1 bg-cover-center" data-background="<?= base_url() ?>assets/img/breadcum/bg.jpg">
                <div class="container">
                    <h2><?= $language == 'hi' ? 'विक्रेता पूछताछ' : 'Vendor Enquriy' ?></h2>
                    <ul>
                        <li><a href="<?= base_url() ?>"><?= $language == 'hi' ? 'होम' : 'Home' ?></a></li>
                        <li><?= $language == 'hi' ? 'विक्रेता पूछताछ' : 'Vendor Enquriy' ?></li>
                    </ul>
                </div>
            </section>
            <!-- Breadcum End -->
            <!-- Send Message Start -->
            <section class="send-message v1 mb-2">
                <div class="container">
                    <div class="row">

                        <div class="col-lg-12">
                            <form id="enquriyForm" method="POST" class="message-form">
                                <div class="row">
                                    <div class="col-6 mb-2">
                                        <label for=""
                                            class="fw-bold"><?= $language == 'hi' ? 'आपका नाम' : 'Your Name' ?></label>
                                        <input type="text" name="name" class="form-control"
                                            placeholder="<?= $language == 'hi' ? 'आपका नाम' : 'Your Name' ?>">
                                    </div>
                                    <div class="col-6 mb-2">
                                        <label for=""
                                            class="fw-bold"><?= $language == 'hi' ? 'आपका ईमेल' : 'Your Email' ?></label>
                                        <input type="email" name="email" class="form-control"
                                            placeholder="alma.lawson@example.com">
                                    </div>
                                    <div class="col-6 mb-2">
                                        <label for=""
                                            class="fw-bold"><?= $language == 'hi' ? 'आपका फोन' : 'Your Phone' ?></label>
                                        <input type="text" name="phone" class="form-control"
                                            placeholder="Enter 10-digit number"
                                            oninput="this.value = this.value.replace(/[^0-9]/g, '').slice(0, 10);" />
                                    </div>
                                    <div class="col-6 mb-2">
                                        <label for=""
                                            class="fw-bold"><?= $language == 'hi' ? 'आपका पता' : 'Your Address' ?></label>
                                        <input type="text" name="address" class="form-control"
                                            placeholder="<?= $language == 'hi' ? 'आपका पता' : 'Your Address' ?>">
                                    </div>
                                    <div class="col-6 mb-2">
                                        <label for="" class="fw-bold">
                                            <?= $language == 'hi' ? 'व्यापार के प्रकार' : 'Type of Business' ?></label>
                                        <input type="text" name="business" class="form-control"
                                            placeholder="<?= $language == 'hi' ? 'व्यापार के प्रकार' : 'Type of Business' ?>">
                                    </div>
                                    <div class="col-12 mb-2">
                                        <label for=""
                                            class="fw-bold"><?= $language == 'hi' ? 'सवाल' : 'Query' ?></label>
                                        <textarea name="query" placeholder="Simultaneously we had a problem"></textarea>
                                    </div>
                                </div>
                                <button type="submit"
                                    class="btn-anime v2 mt-2"><?= $language == 'hi' ? 'मेसेज भेजें' : 'send message' ?></button>

                            </form>
                        </div>
                    </div>
                    <!-- Toast Notification Container -->
                    <div id="toast" style="
                                    visibility: hidden;
                                    min-width: 250px;
                                    background: #333;
                                    color: #fff;
                                    text-align: left;
                                    border-radius: 8px;
                                    padding: 16px;
                                    position: fixed;
                                    right: -23rem;
                                    bottom: 20px;
                                    z-index: 9999;
                                    transition: all 0.5s ease;
                                "></div>
                </div>
            </section>
            <!-- Send Message End -->

        </main>

        <?php include_once('common_page/footer.php'); ?>
    </div>
    <?php include_once('common_page/script.php'); ?>

    <script>
        $(document).ready(function () {
            $("#enquriyForm").on("submit", function (e) {
                e.preventDefault(); // Stop normal form submission

                $(".error").html(""); // Clear errors


                $.ajax({
                    url: "<?= base_url('business/save') ?>",
                    type: "POST",
                    data: $(this).serialize(),
                    dataType: "json",
                    success: function (response) {
                        if (response.status === "error") {
                            $.each(response.errors, function (key, value) {
                                $("#error-" + key).html(value);
                            });
                        } else if (response.status === "success") {
                            $("#enquriyForm")[0].reset();
                            showToast(response.message, "success");
                        }
                    },
                    error: function () {
                        showToast("Something went wrong. Try again.", "error");
                    }
                });
            });

            // Toast function
            function showToast(message, type) {
                var toast = $("#toast");
                toast.html(message);

                if (type === "success") {
                    toast.css("background", "#28a745");
                } else {
                    toast.css("background", "#dc3545");
                }

                toast.css("visibility", "visible").css("right", "20px");

                setTimeout(function () {
                    toast.css("right", "-23rem");
                }, 3000); // hide after 3 seconds
            }
        });
    </script>
</body>

</html>