<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Member_corner extends MY_Controller
{
    public function index()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'Report_model', 'page_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['report'] = $this->Report_model->get_all();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('annual-reports', $data);
    }
    public function membership_eligibility()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model', 'Membership_eligibility_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['membership'] = $this->Membership_eligibility_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('membership-eligibility', $data);
    }
    public function dividend_history()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'Dividend_model', 'page_model', 'unpaid_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['dividend'] = $this->Dividend_model->get_all();
        $data['page'] = $this->page_model->get_all();
        $data['unpaid'] = $this->unpaid_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('dividend-history', $data);
    }
    public function gallery()
    {
        $this->load->model(['Product_model', 'Service_model', 'gallery_model', 'Campaign_model', 'page_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['gallery'] = $this->gallery_model->get_all();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('gallery', $data);
    }
    public function video_gallery()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'page_model', 'video_gallery_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['gallery'] = $this->video_gallery_model->get_all();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('video-gallery', $data);
    }
    public function awards_and_recognition()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'Award_model', 'page_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['award'] = $this->Award_model->get_all();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('awards-and-recognition', $data);
    }
    public function news_and_events()
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'page_model', 'news_model', 'Counter_model']);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['news'] = $this->news_model->get_all();
        $data['category'] = $this->news_model->get_all_category();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('news-and-event', $data);
    }


    public function news_details($slug)
    {
        $this->load->model(['news_model', 'Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model']);
        $slug = urldecode($slug);
        $data['news'] = $this->news_model->get_all();
        $data['category'] = $this->news_model->get_all_category();
        $data['details'] = $this->news_model->get_news_by_title($slug);

        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('news-details', $data);
    }

    public function new_page($slug)
    {
        $this->load->model(['Product_model', 'Service_model', 'Campaign_model', 'page_model', 'Counter_model']);
        $slug = urldecode($slug);
        $data['product'] = $this->Product_model->get_all_product();
        $data['service'] = $this->Service_model->get_all_service();
        $data['active_campaigns'] = $this->Campaign_model->get_active_campaign();
        $data['single_page'] = $this->page_model->get_page_by_slug($slug);
        $data['page'] = $this->page_model->get_all();
        $data['total_visits'] = $this->Counter_model->get_count();
        $this->load->view('new-page', $data);
    }


}