<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class About extends CI_Controller
{
    public function index()
    {
        $this->load->model('about_model');
        $data['about'] = $this->about_model->get_all();
        $this->load->view('admin/about', $data);
    }
    public function add_about()
    {
        $this->load->view('admin/add-about');
    }

    public function submit_about_details()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'title' => form_error('title'),
                    'hindi_title' => form_error('hindi_title'),
                    'content' => form_error('content'),
                    'hindi_content' => form_error('hindi_content'),
                ]
            ]);
            return;
        }

        // Check if record exists (only 1 record allowed)
        $this->load->model('about_model');
        $existing = $this->about_model->get_single_about(); // Only one row

        $uploadPath = './uploads/about/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif';
        $config['max_size'] = 5120;
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        $imageFields = ['featured_image_one', 'featured_image_two'];
        $uploadedFiles = [];

        foreach ($imageFields as $field) {

            if (!empty($_FILES[$field]['name'])) {

                if (!$this->upload->do_upload($field)) {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }

                $fileData = $this->upload->data();
                $uploadedFiles[$field] = 'uploads/about/' . $fileData['file_name'];
            } else {
                // If updating and old image exists → keep old image
                if (!empty($existing->$field)) {
                    $uploadedFiles[$field] = $existing->$field;
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => 'Please select ' . str_replace('_', ' ', $field)]
                    ]);
                    return;
                }
            }
        }

        $aboutData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
            'featured_image_one' => $uploadedFiles['featured_image_one'],
            'featured_image_two' => $uploadedFiles['featured_image_two']
        ];

        if ($existing) {

            $this->about_model->update_about_details($existing->id, $aboutData);
            $this->session->set_flashdata('message', 'About Details Update successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('about-list')
            ]);

        } else {

            $aboutData['created_at'] = date('Y-m-d H:i:s');
            $this->about_model->add_about_details($aboutData);
            $this->session->set_flashdata('message', 'About Details added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('about-list')
            ]);
        }
    }

    public function edit_about($id)
    {
        $this->load->model('about_model');
        $data['details'] = $this->about_model->get_about_details_by_id($id);

        $this->load->view('admin/edit-about', $data);
    }


    public function update_about_details()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'title' => form_error('title'),
                    'hindi_title' => form_error('hindi_title'),
                    'content' => form_error('content'),
                    'hindi_content' => form_error('hindi_content'),
                ]
            ]);
            return;
        }

        $id = $this->input->post('id');

        $uploadPath = './uploads/about/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif';
        $config['max_size'] = 5120;
        $config['encrypt_name'] = TRUE;
        $config['detect_mime'] = FALSE;   // ⭐ FilePond blob fix
        $config['overwrite'] = TRUE;    // ⭐ Required for blob handling

        $this->load->library('upload', $config);

        $imageFields = ['featured_image_one', 'featured_image_two'];
        $uploadedFiles = [];

        foreach ($imageFields as $field) {

            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $fileData = $this->upload->data();
                    $uploadedFiles[$field] = 'uploads/about/' . $fileData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        $aboutData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        foreach ($uploadedFiles as $key => $val) {
            $aboutData[$key] = $val;
        }

        $this->load->model('about_model');

        if ($id) {
            $this->about_model->update_about_details($id, $aboutData);
            $this->session->set_flashdata('message', 'About Details Update successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('about-list')
            ]);
        } else {

            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Database error']
            ]);

        }
    }

    public function delete_about($id)
    {
        $this->load->model('about_model');
        $this->about_model->delete_about_details($id);
        $this->session->set_flashdata('message', 'About details delete successfully');
        redirect(base_url('about-list'));

    }


    public function chairman_note()
    {
        $this->load->model('about_model');
        $data['note'] = $this->about_model->get_all_chairman_note();
        $this->load->view('admin/chairman-note', $data);
    }

    public function add_chairman_note()
    {
        $this->load->view('admin/add-chairman-note');
    }

    public function submit_chairman_note()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'content' => form_error('content'),
                    'hindi_content' => form_error('hindi_content'),
                ]
            ]);
            return;
        }

        // Check if record exists (only 1 record allowed)
        $this->load->model('about_model');
        $existing = $this->about_model->get_single_chairman_note(); // Only one row

        $uploadPath = './uploads/chairman-note/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif';
        $config['max_size'] = 5120;
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        $imageFields = ['featured_image'];
        $uploadedFiles = [];

        foreach ($imageFields as $field) {

            if (!empty($_FILES[$field]['name'])) {

                if (!$this->upload->do_upload($field)) {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }

                $fileData = $this->upload->data();
                $uploadedFiles[$field] = 'uploads/chairman-note/' . $fileData['file_name'];
            } else {
                // If updating and old image exists → keep old image
                if (!empty($existing->$field)) {
                    $uploadedFiles[$field] = $existing->$field;
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => 'Please select ' . str_replace('_', ' ', $field)]
                    ]);
                    return;
                }
            }
        }

        $chairman_noteData = [
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
            'featured_image' => $uploadedFiles['featured_image'],
            'created_at' => date('Y-m-d H:i:s')
        ];

        if ($existing) {
            $this->about_model->update_chairman_note($existing->id, $chairman_noteData);
            $this->session->set_flashdata('message', 'Chairman note updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('chairman-note')
            ]);
        } else {
            $this->about_model->add_chairman_note($chairman_noteData);
            $this->session->set_flashdata('message', 'Chairman note added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('chairman-note')
            ]);
        }
    }

    public function edit_chairman_note($id)
    {
        $this->load->model('about_model');
        $data['details'] = $this->about_model->get_chairman_note_by_id($id);

        $this->load->view('admin/edit-chairman-note', $data);
    }

    public function update_chairman_note()
    {
        $this->form_validation->set_error_delimiters('', '');


        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'content' => form_error('content'),
                    'hindi_content' => form_error('hindi_content'),
                ]
            ]);
            return;
        }

        $id = $this->input->post('id');

        $uploadPath = './uploads/chairman-note/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif';
        $config['max_size'] = 5120;
        $config['encrypt_name'] = TRUE;
        $config['detect_mime'] = FALSE;   // ⭐ FilePond blob fix
        $config['overwrite'] = TRUE;    // ⭐ Required for blob handling

        $this->load->library('upload', $config);

        $imageFields = ['featured_image'];
        $uploadedFiles = [];

        foreach ($imageFields as $field) {

            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $fileData = $this->upload->data();
                    $uploadedFiles[$field] = 'uploads/chairman-note/' . $fileData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        $aboutData = [
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        foreach ($uploadedFiles as $key => $val) {
            $aboutData[$key] = $val;
        }

        $this->load->model('about_model');

        if ($id) {
            $this->about_model->update_chairman_note($id, $aboutData);
            $this->session->set_flashdata('message', 'chairman note Update successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('chairman-note')
            ]);
        } else {

            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Database error']
            ]);

        }
    }

    public function delete_chairman_note($id)
    {
        $this->load->model('about_model');
        $this->about_model->delete_chairman_note($id);
        $this->session->set_flashdata('message', 'chairman note delete successfully');
        redirect(base_url('chairman-note'));

    }

    public function operational_model()
    {
        $this->load->model('about_model');
        $data['model'] = $this->about_model->get_all_operational_model();
        $this->load->view('admin/operational-model', $data);
    }

    public function add_operational_model()
    {
        $this->load->view('admin/add-operational-model');
    }

    public function submit_operational_model()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'content' => form_error('content'),
                    'hindi_content' => form_error('hindi_content'),
                ]
            ]);
            return;
        }

        // Check if record exists (only 1 record allowed)
        $this->load->model('about_model');
        $existing = $this->about_model->get_single_operational_model(); // Only one row

        $uploadPath = './uploads/operational-model/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif';
        $config['max_size'] = 5120;
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        $imageFields = ['featured_image'];
        $uploadedFiles = [];

        foreach ($imageFields as $field) {

            if (!empty($_FILES[$field]['name'])) {

                if (!$this->upload->do_upload($field)) {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }

                $fileData = $this->upload->data();
                $uploadedFiles[$field] = 'uploads/operational-model/' . $fileData['file_name'];
            } else {
                // If updating and old image exists → keep old image
                if (!empty($existing->$field)) {
                    $uploadedFiles[$field] = $existing->$field;
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => 'Please select ' . str_replace('_', ' ', $field)]
                    ]);
                    return;
                }
            }
        }

        $chairman_noteData = [
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
            'featured_image' => $uploadedFiles['featured_image'],
            'created_at' => date('Y-m-d H:i:s')
        ];

        if ($existing) {
            $this->about_model->update_operational_model($existing->id, $chairman_noteData);
            $this->session->set_flashdata('message', 'Operational Model updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('operational-model')
            ]);
        } else {
            $this->about_model->add_operational_model($chairman_noteData);
            $this->session->set_flashdata('message', 'Operational Model added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('operational-model')
            ]);
        }
    }

    public function edit_operational_model($id)
    {
        $this->load->model('about_model');
        $data['details'] = $this->about_model->get_operational_model_by_id($id);

        $this->load->view('admin/edit-operational-model', $data);
    }

    public function update_operational_model()
    {
        $this->form_validation->set_error_delimiters('', '');


        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'content' => form_error('content'),
                    'hindi_content' => form_error('hindi_content'),
                ]
            ]);
            return;
        }

        $id = $this->input->post('id');

        $uploadPath = './uploads/operational-model/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif';
        $config['max_size'] = 5120;
        $config['encrypt_name'] = TRUE;
        $config['detect_mime'] = FALSE;   // ⭐ FilePond blob fix
        $config['overwrite'] = TRUE;    // ⭐ Required for blob handling

        $this->load->library('upload', $config);

        $imageFields = ['featured_image'];
        $uploadedFiles = [];

        foreach ($imageFields as $field) {

            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $fileData = $this->upload->data();
                    $uploadedFiles[$field] = 'uploads/operational-model/' . $fileData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        $aboutData = [
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        foreach ($uploadedFiles as $key => $val) {
            $aboutData[$key] = $val;
        }

        $this->load->model('about_model');

        if ($id) {
            $this->about_model->update_operational_model($id, $aboutData);
            $this->session->set_flashdata('message', 'operational model Update successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('operational-model')
            ]);
        } else {

            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Database error']
            ]);

        }
    }

    public function delete_operational_model($id)
    {
        $this->load->model('about_model');
        $this->about_model->delete_operational_model($id);
        $this->session->set_flashdata('message', 'Operational Model delete successfully');
        redirect(base_url('operational-model'));

    }

}