<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Blog extends CI_Controller
{


    public function index()
    {
        $this->load->model('blog_model');
        $data['blogs'] = $this->blog_model->get_all();
        $data['category'] = $this->blog_model->get_all_category();
        $this->load->view('admin/blogs', $data);
    }


    public function blog_category()
    {
        $this->load->model('blog_model');
        $data['category'] = $this->blog_model->get_all_category();
        $this->load->view('admin/blog-category', $data);
    }
    public function add_blog_category()
    {

        $this->load->view('admin/add-blog-category');
    }

    public function submit_blog_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $blogCategory = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        $this->load->model('blog_model');
        $insert_id = $this->blog_model->add_blog_category($blogCategory);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Blog Category added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('blog-category')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Blog Category, try again.']
            ]);
        }
    }


    public function edit_blog_category($id)
    {
        $this->load->model('blog_model');
        $data['category'] = $this->blog_model->get_blog_category_by_id($id);
        $this->load->view('admin/edit-blog-category', $data);
    }

    public function delete_blog_category($id)
    {
        $this->load->model('blog_model');
        $this->blog_model->delete_blog_category($id);
        $this->session->set_flashdata('message', 'Blog Category delete successfully');
        redirect(base_url('blog-category'));

    }


    public function update_blog_category()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $categoryData = [
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
        ];

        // Upload folder config


        // Load model
        $this->load->model('blog_model');
        // ✅ Update blog
        $updated = $this->blog_model->update_blog_category($id, $categoryData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Blog Category updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('blog-category')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Blog Category, please try again.']
            ]);
        }
    }




    public function add_blog()
    {
        $this->load->model('blog_model');
        $data['category'] = $this->blog_model->get_all_category();
        $this->load->view('admin/add-blog', $data);
    }
    public function submit_blog()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('slug', 'Slug', 'required|trim');
        $this->form_validation->set_rules('hindi_slug', 'Hindi Slug', 'required|trim');
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        $this->form_validation->set_rules('author', 'Author', 'required|trim');
        $this->form_validation->set_rules('hindi_author', 'Hindi Author', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'slug' => form_error('slug'),
                'hindi_slug' => form_error('hindi_slug'),
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
                'author' => form_error('author'),
                'hindi_author' => form_error('hindi_author'),
                'content' => form_error('content'),
                'hindi_content' => form_error('hindi_content'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $blogData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'slug' => $this->input->post('slug'),
            'hindi_slug' => $this->input->post('hindi_slug'),
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
            'author' => $this->input->post('author'),
            'hindi_author' => $this->input->post('hindi_author'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/blogs/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $blogData['featured_image'] = 'uploads/blogs/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_image' => 'Please select an image']
            ]);
            return;
        }

        // Save blog
        $this->load->model('blog_model');
        $blog_id = $this->blog_model->add_blog($blogData);

        if ($blog_id) {
            $this->session->set_flashdata('message', 'Blog added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('blogs-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Blog, try again.']
            ]);
        }
    }
    public function delete_blog($id)
    {
        $this->load->model('blog_model');
        $this->blog_model->delete_blog($id);
        $this->session->set_flashdata('message', 'Blog delete successfully');
        redirect(base_url('blogs-list'));

    }
    public function set_status($id)
    {
        $this->load->model('blog_model');
        $new_status = $this->blog_model->set_status($id);

        if ($new_status) {
            $this->session->set_flashdata('message', "Blog $new_status successfully");
        } else {
            $this->session->set_flashdata('message', "Blog not found");
        }

        redirect(base_url('blogs-list'));
    }


    public function edit_blog($id)
    {
        $this->load->model('blog_model');
        $data['blog'] = $this->blog_model->get_blog_by_id($id);
        $data['category'] = $this->blog_model->get_all_category();
        $this->load->view('admin/edit-blog', $data);
    }


    public function update_blog()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('title', 'Title', 'required|trim');
        $this->form_validation->set_rules('hindi_title', 'Hindi Title', 'required|trim');
        $this->form_validation->set_rules('slug', 'Slug', 'required|trim');
        $this->form_validation->set_rules('hindi_slug', 'Hindi Slug', 'required|trim');
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('hindi_category', 'Hindi Category', 'required|trim');
        $this->form_validation->set_rules('author', 'Author', 'required|trim');
        $this->form_validation->set_rules('hindi_author', 'Hindi Author', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'required|trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title' => form_error('title'),
                'hindi_title' => form_error('hindi_title'),
                'slug' => form_error('slug'),
                'hindi_slug' => form_error('hindi_slug'),
                'category' => form_error('category'),
                'hindi_category' => form_error('hindi_category'),
                'author' => form_error('author'),
                'hindi_author' => form_error('hindi_author'),
                'content' => form_error('content'),
                'hindi_content' => form_error('hindi_content'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $blogData = [
            'title' => $this->input->post('title'),
            'hindi_title' => $this->input->post('hindi_title'),
            'slug' => $this->input->post('slug'),
            'hindi_slug' => $this->input->post('hindi_slug'),
            'category' => $this->input->post('category'),
            'hindi_category' => $this->input->post('hindi_category'),
            'author' => $this->input->post('author'),
            'hindi_author' => $this->input->post('hindi_author'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/blogs/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // Load model
        $this->load->model('blog_model');

        // Get old image to delete if replaced
        $oldBlog = $this->blog_model->get_blog_by_id($id);
        $oldImage = $oldBlog ? $oldBlog->featured_image : '';

        // ✅ If new image uploaded, replace old one
        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $blogData['featured_image'] = 'uploads/blogs/' . $uploadData['file_name'];

                // Delete old image (if exists)
                if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                    unlink('./' . $oldImage);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // ✅ Update blog
        $updated = $this->blog_model->update_blog($id, $blogData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Blog updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('blogs-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Blog, please try again.']
            ]);
        }
    }



}