<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Create_page extends CI_Controller
{
    public function index()
    {
        $this->load->model('page_model');
        $data['pages'] = $this->page_model->get_all();
        $this->load->view('admin/create-page', $data);
    }
    public function add_page()
    {
        $this->load->view('admin/add-page');
    }

    public function upload_ck_image()
    {
        if (!empty($_FILES['upload']['name'])) {

            $fileName = time() . '_' . preg_replace("/[^a-zA-Z0-9.]/", "_", $_FILES['upload']['name']);
            $uploadPath = FCPATH . 'uploads/pages/';

            if (!is_dir($uploadPath)) {
                mkdir($uploadPath, 0777, true);
            }

            $fullPath = $uploadPath . $fileName;

            if (move_uploaded_file($_FILES['upload']['tmp_name'], $fullPath)) {
                // ✅ CKEditor expects *exactly* this JSON structure
                echo json_encode([
                    "uploaded" => 1,
                    "fileName" => $fileName,
                    "url" => base_url('uploads/pages/' . $fileName)
                ]);
            } else {
                echo json_encode([
                    "uploaded" => 0,
                    "error" => ["message" => "File move failed."]
                ]);
            }

        } else {
            echo json_encode([
                "uploaded" => 0,
                "error" => ["message" => "No file received."]
            ]);
        }
    }

    public function submit_page()
    {
        $this->load->library('form_validation');
        $this->form_validation->set_error_delimiters('', '');
        $this->form_validation->set_rules('page_name', 'Page Name', 'required|trim');
        $this->form_validation->set_rules('hindi_page_name', 'Hindi Page Name', 'required|trim');
        $this->form_validation->set_rules('slug', 'Slug', 'required|trim|regex_match[/^[a-z0-9-]+$/]');

        if ($this->form_validation->run() == FALSE) {
            echo json_encode([
                'status' => 'error',
                'errors' => [
                    'page_name' => form_error('page_name'),
                    'hindi_page_name' => form_error('hindi_page_name'),
                    'slug' => form_error('slug')
                ]
            ]);
            return;
        }

        $this->load->model('page_model');

        $data = [
            'page_name' => $this->input->post('page_name'),
            'hindi_page_name' => $this->input->post('hindi_page_name'),
            'slug' => $this->input->post('slug'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content')
        ];

        $id = $this->page_model->add_page($data);

        if ($id) {
            echo json_encode(['status' => 'success', 'redirect' => base_url('create-page-list')]);
        } else {
            echo json_encode(['status' => 'error', 'errors' => ['db' => 'Failed to save page']]);
        }
    }
}