<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dividend_history extends CI_Controller
{
    public function index()
    {
        $this->load->model('dividend_model');
        $data['dividend_history'] = $this->dividend_model->get_all();
        $this->load->view('admin/dividend-history', $data);
    }

    public function add_dividend_history()
    {
        $this->load->view('admin/add-dividend-history');
    }


    public function submit_dividend_history()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('rate', 'Rate of dividend including DDT', 'required|trim');
        $this->form_validation->set_rules('shares', 'No. of shares', 'required|trim');
        $this->form_validation->set_rules('total_amount', 'Total Amount', 'required|trim');
        $this->form_validation->set_rules('year', 'Year', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'rate' => form_error('rate'),
                'shares' => form_error('shares'),
                'total_amount' => form_error('total_amount'),
                'year' => form_error('year'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $reportCategory = [
            'rate' => $this->input->post('rate'),
            'shares' => $this->input->post('shares'),
            'total_amount' => $this->input->post('total_amount'),
            'year' => $this->input->post('year'),
        ];

        $this->load->model('dividend_model');
        $insert_id = $this->dividend_model->add_dividend_history($reportCategory);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Dividend History added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('dividend-history-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Dividend History, try again.']
            ]);
        }
    }

    public function edit_dividend_history($id)
    {
        $this->load->model('dividend_model');
        $data['data'] = $this->dividend_model->get_dividend_history_by_id($id);
        $this->load->view('admin/edit-dividend-history', $data);
    }

    public function delete_dividend_history($id)
    {
        $this->load->model('dividend_model');
        $this->dividend_model->delete_dividend_history($id);
        $this->session->set_flashdata('message', 'Dividend History delete successfully');
        redirect(base_url('dividend-history-list'));
    }


    public function update_dividend_history()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('rate', 'Rate of dividend including DDT', 'required|trim');
        $this->form_validation->set_rules('shares', 'No. of shares', 'required|trim');
        $this->form_validation->set_rules('total_amount', 'Total Amount', 'required|trim');
        $this->form_validation->set_rules('year', 'Year', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'rate' => form_error('rate'),
                'shares' => form_error('shares'),
                'total_amount' => form_error('total_amount'),
                'year' => form_error('year'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }



        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $reportData = [
            'rate' => $this->input->post('rate'),
            'shares' => $this->input->post('shares'),
            'total_amount' => $this->input->post('total_amount'),
            'year' => $this->input->post('year'),
        ];

        // Upload folder config


        // Load model
        $this->load->model('dividend_model');
        // ✅ Update blog
        $updated = $this->dividend_model->update_dividend_history($id, $reportData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Dividend History updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('dividend-history-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Dividend History, please try again.']
            ]);
        }
    }
}