<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Job_post extends CI_Controller
{
    public function index()
    {
        $this->load->model('job_model');
        $data['jobs'] = $this->job_model->get_all();
        $this->load->view('admin/job-post', $data);
    }

    public function add_job_post()
    {
        $this->load->view('admin/add-job-post');
    }

    public function submit_job_post()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('position_name', 'position_name', 'required|trim');
        $this->form_validation->set_rules('hindi_position_name', 'Hindi position_name', 'required|trim');
        $this->form_validation->set_rules('job_location', 'job_location', 'required|trim');
        $this->form_validation->set_rules('hindi_job_location', 'hindi_job_location', 'required|trim');
        $this->form_validation->set_rules('qualification', 'qualification', 'required|trim');
        $this->form_validation->set_rules('hindi_qualification', 'hindi_qualification', 'required|trim');
        $this->form_validation->set_rules('job_responsibility', 'job_responsibility', 'required|trim');
        $this->form_validation->set_rules('hindi_job_responsibility', 'hindi_job_responsibility', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'position_name' => form_error('position_name'),
                'hindi_position_name' => form_error('hindi_position_name'),
                'job_location' => form_error('job_location'),
                'hindi_job_location' => form_error('hindi_job_location'),
                'qualification' => form_error('qualification'),
                'hindi_qualification' => form_error('hindi_qualification'),
                'job_responsibility' => form_error('job_responsibility'),
                'hindi_job_responsibility' => form_error('hindi_job_responsibility'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $jobData = [
            'position_name' => $this->input->post('position_name'),
            'hindi_position_name' => $this->input->post('hindi_position_name'),
            'job_location' => $this->input->post('job_location'),
            'hindi_job_location' => $this->input->post('hindi_job_location'),
            'qualification' => $this->input->post('qualification'),
            'hindi_qualification' => $this->input->post('hindi_qualification'),
            'job_responsibility' => $this->input->post('job_responsibility'),
            'hindi_job_responsibility' => $this->input->post('hindi_job_responsibility'),
        ];

        $this->load->model('job_model');
        $insert_id = $this->job_model->add_job_post($jobData);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Job Post added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('job-post-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Job Post, try again.']
            ]);
        }
    }

    public function edit_job_post($id)
    {
        $this->load->model('job_model');
        $data['jobs'] = $this->job_model->get_job_post_by_id($id);
        $this->load->view('admin/edit-job-post', $data);
    }

    public function update_job_post()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('position_name', 'position_name', 'required|trim');
        $this->form_validation->set_rules('hindi_position_name', 'Hindi position_name', 'required|trim');
        $this->form_validation->set_rules('job_location', 'job_location', 'required|trim');
        $this->form_validation->set_rules('hindi_job_location', 'hindi_job_location', 'required|trim');
        $this->form_validation->set_rules('qualification', 'qualification', 'required|trim');
        $this->form_validation->set_rules('hindi_qualification', 'hindi_qualification', 'required|trim');
        $this->form_validation->set_rules('job_responsibility', 'job_responsibility', 'required|trim');
        $this->form_validation->set_rules('hindi_job_responsibility', 'hindi_job_responsibility', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'position_name' => form_error('position_name'),
                'hindi_position_name' => form_error('hindi_position_name'),
                'job_location' => form_error('job_location'),
                'hindi_job_location' => form_error('hindi_job_location'),
                'qualification' => form_error('qualification'),
                'hindi_qualification' => form_error('hindi_qualification'),
                'job_responsibility' => form_error('job_responsibility'),
                'hindi_job_responsibility' => form_error('hindi_job_responsibility'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $id = $this->input->post('id');

        $jobData = [
            'position_name' => $this->input->post('position_name'),
            'hindi_position_name' => $this->input->post('hindi_position_name'),
            'job_location' => $this->input->post('job_location'),
            'hindi_job_location' => $this->input->post('hindi_job_location'),
            'qualification' => $this->input->post('qualification'),
            'hindi_qualification' => $this->input->post('hindi_qualification'),
            'job_responsibility' => $this->input->post('job_responsibility'),
            'hindi_job_responsibility' => $this->input->post('hindi_job_responsibility'),
        ];

        $this->load->model('job_model');
        $insert_id = $this->job_model->update_job_post($id, $jobData);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Job Post update successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('job-post-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Job Post, try again.']
            ]);
        }
    }

    public function set_status($id)
    {
        $this->load->model('job_model');
        $new_status = $this->job_model->set_status($id);

        if ($new_status) {
            $this->session->set_flashdata('message', "Job Post $new_status successfully");
        } else {
            $this->session->set_flashdata('message', "Job Post not found");
        }

        redirect(base_url('job-post-list'));
    }
    
    public function job_applications()
    {
        $this->load->model('job_model');
        $data['application'] = $this->job_model->get_applications();
        $this->load->view('admin/job-application', $data);
    }
    
        public function view_applicaton($id)
    {
        $this->load->model('job_model');
        $data['application'] = $this->job_model->get_applications_by_id($id);
        $this->load->view('admin/view-application', $data);
    }
    
     public function delete_application($id)
    {
        $this->load->model('job_model');
        $this->job_model->delete_application($id);
        $this->session->set_flashdata('message', 'Appliaction delete successfully');
        redirect(base_url('job-applications-list'));

    }
}