<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Login extends CI_Controller
{

	public function index()
	{

		if ($this->session->userdata('admin_id')) {
			return redirect('dashboard');
		}


		$remember_me = get_cookie('remember_me');
		if ($remember_me) {
			$data = explode('::', base64_decode($remember_me));
			$admin_id = $data[0] ?? null;
			$email = $data[1] ?? null;

			if ($admin_id && $email) {
				$this->load->model('Admin_model');
				$user = $this->Admin_model->get_admin_by_id_email($admin_id, $email);

				if ($user) {
					$sessionData = array(
						'admin_id' => $user->admin_id,
						'email' => $user->email,
					);
					$this->session->set_userdata($sessionData);

					return redirect('dashboard');
				}
			}
		}
		$this->load->view('admin/auth-sign-in');
	}
	public function register()
	{
		$this->load->view('admin/auth-sign-up');
	}


	public function admin_login()
	{
		$this->form_validation->set_rules('email', 'Email', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required');
		$this->form_validation->set_error_delimiters('<div class="error">', '</div>');

		if ($this->form_validation->run() == true) {
			$email = $this->input->post('email');
			$password = sha1($this->input->post('password'));
			$remember = $this->input->post('remember');
			$this->load->model('Admin_model');
			$user = $this->Admin_model->admin_exist($email, $password);

			if ($user) {
				$sessionData = array(
					'admin_id' => $user->admin_id,
					'email' => $user->email,
				);
				$this->session->set_userdata($sessionData);

				if ($remember) {
					$cookie = array(
						'name' => 'remember_me',
						'value' => base64_encode($user->admin_id . '::' . $user->email),
						'expire' => 60 * 60 * 24 * 30, // 30 days
						'secure' => false
					);
					$this->input->set_cookie($cookie);
				}

				return redirect('dashboard');
			} else {
				$this->session->set_flashdata('message', '<div class="alert alert-danger text-center">Invalid Username/Email or Password.</div>');
				$this->load->view('admin/auth-sign-in');
			}
		} else {
			$this->session->set_flashdata('message', '<div class="alert alert-danger text-center">Please Enter Username/Email and Password.</div>');
			$this->load->view('admin/auth-sign-in');
		}
	}
	public function add_admin()
	{
		// Validation Rules
		$this->form_validation->set_rules('name', 'Name', 'required|trim');
		$this->form_validation->set_rules('email', 'Email', 'required');
		$this->form_validation->set_rules('password', 'Password', 'required|min_length[6]');

		if ($this->form_validation->run() == FALSE) {
			// Load register view with errors
			redirect('register');
		} else {
			// Get input
			$data = array(
				'name' => $this->input->post('name', TRUE),
				'email' => $this->input->post('email', TRUE),
				'password' => sha1($this->input->post('password')),
			);
			$this->load->model('Admin_model');
			// Save to DB
			$insert_id = $this->Admin_model->insert_admin($data);

			if ($insert_id) {
				$this->session->set_flashdata('success', 'Admin registered successfully. You can now login.');
				redirect('login');
			} else {
				$this->session->set_flashdata('error', 'Something went wrong. Please try again.');
				redirect('register');
			}
		}
	}
}
