<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Membership_eligibility extends CI_Controller
{
    public function index()
    {
        $this->load->model('membership_eligibility_model');
        $data['membership'] = $this->membership_eligibility_model->get_all();
        $this->load->view('admin/membership-eligibility', $data);
    }

    public function add_membership_eligibility()
    {
        $this->load->view('admin/add-membership-eligibility');
    }

    public function submit_membership_eligibility()
    {
        $this->form_validation->set_error_delimiters('', '');

        $this->form_validation->set_rules('title_one', 'Title One', 'required|trim');
        $this->form_validation->set_rules('hindi_title_one', 'Hindi Title One', 'required|trim');
        $this->form_validation->set_rules('content_one', 'Content One', 'required|trim');
        $this->form_validation->set_rules('hindi_content_one', 'Hindi Content One', 'required|trim');
        $this->form_validation->set_rules('title_two', 'Title Two', 'required|trim');
        $this->form_validation->set_rules('hindi_title_two', 'Hindi Title Two', 'required|trim');
        $this->form_validation->set_rules('content_two', 'Content Two', 'required|trim');
        $this->form_validation->set_rules('hindi_content_two', 'Hindi Content Two', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title_one' => form_error('title_one'),
                'hindi_title_one' => form_error('hindi_title_one'),
                'content_one' => form_error('content_one'),
                'hindi_content_one' => form_error('hindi_content_one'),
                'title_two' => form_error('title_two'),
                'hindi_title_two' => form_error('hindi_title_two'),
                'content_two' => form_error('content_two'),
                'hindi_content_two' => form_error('hindi_content_two'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data
        $serviceData = [
            'title_one' => $this->input->post('title_one'),
            'hindi_title_one' => $this->input->post('hindi_title_one'),
            'content_one' => $this->input->post('content_one'),
            'hindi_content_one' => $this->input->post('hindi_content_one'),
            'title_two' => $this->input->post('title_two'),
            'hindi_title_two' => $this->input->post('hindi_title_two'),
            'content_two' => $this->input->post('content_two'),
            'hindi_content_two' => $this->input->post('hindi_content_two'),
            'created_at' => date('Y-m-d H:i:s'),
        ];

        $uploadPath = './uploads/membership-eligibility/';
        if (!is_dir($uploadPath))
            mkdir($uploadPath, 0777, true);

        // IMAGE CONFIG
        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120,
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Upload Images ===
        $imageFields = ['featured_image_one', 'featured_image_two'];

        foreach ($imageFields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $uploadData = $this->upload->data();
                    $serviceData[$field] = 'uploads/membership-eligibility/' . $uploadData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        // === Upload PDF ===
        if (!empty($_FILES['pdf']['name'])) {

            $pdfConfig = [
                'upload_path' => $uploadPath,
                'allowed_types' => 'pdf',
                'max_size' => 10000,
                'encrypt_name' => TRUE,
            ];

            $this->upload->initialize($pdfConfig);

            if ($this->upload->do_upload('pdf')) {
                $pdfData = $this->upload->data();
                $serviceData['pdf'] = 'uploads/membership-eligibility/' . $pdfData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['pdf' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // MODEL CALL
        $this->load->model('membership_eligibility_model');
        $existing = $this->membership_eligibility_model->get_membership_eligibility();

        if ($existing) {
            $update = $this->membership_eligibility_model->update_membership_eligibility($existing->id, $serviceData);
            echo json_encode(['status' => 'success', 'redirect' => base_url('membership-eligibility-list')]);
        } else {
            $this->membership_eligibility_model->add_membership_eligibility($serviceData);
            echo json_encode(['status' => 'success', 'redirect' => base_url('membership-eligibility-list')]);
        }
    }


    public function edit_membership_eligibility($id)
    {
        $this->load->model('membership_eligibility_model');
        $data['details'] = $this->membership_eligibility_model->get_membership_eligibility_by_id($id);
        $this->load->view('admin/edit-membership-eligibility', $data);
    }

    public function update_membership_eligibility()
    {
        $this->form_validation->set_error_delimiters('', '');

        // === Validation Rules ===
        $this->form_validation->set_rules('title_one', 'Title One', 'required|trim');
        $this->form_validation->set_rules('hindi_title_one', 'Hindi Title One', 'required|trim');
        $this->form_validation->set_rules('content_one', 'Content One', 'required|trim');
        $this->form_validation->set_rules('hindi_content_one', 'Hindi Content One', 'required|trim');
        $this->form_validation->set_rules('title_two', 'Title Two', 'required|trim');
        $this->form_validation->set_rules('hindi_title_two', 'Hindi Title Two', 'required|trim');
        $this->form_validation->set_rules('content_two', 'Content Two', 'required|trim');
        $this->form_validation->set_rules('hindi_content_two', 'Hindi Content Two', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'title_one' => form_error('title_one'),
                'hindi_title_one' => form_error('hindi_title_one'),
                'content_one' => form_error('content_one'),
                'hindi_content_one' => form_error('hindi_content_one'),
                'title_two' => form_error('title_two'),
                'hindi_title_two' => form_error('hindi_title_two'),
                'content_two' => form_error('content_two'),
                'hindi_content_two' => form_error('hindi_content_two'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data ===
        $id = $this->input->post('id');
        $serviceData = [
            'title_one' => $this->input->post('title_one'),
            'hindi_title_one' => $this->input->post('hindi_title_one'),
            'content_one' => $this->input->post('content_one'),
            'hindi_content_one' => $this->input->post('hindi_content_one'),
            'title_two' => $this->input->post('title_two'),
            'hindi_title_two' => $this->input->post('hindi_title_two'),
            'content_two' => $this->input->post('content_two'),
            'hindi_content_two' => $this->input->post('hindi_content_two'),
            'created_at' => date('Y-m-d H:i:s'),
        ];

        // === Upload Config ===
        $uploadPath = './uploads/membership-eligibility/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120,
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Load Model & Get Current Record ===
        $this->load->model('membership_eligibility_model');
        $current = $this->membership_eligibility_model->get_membership_eligibility_by_id($id);

        // === Update Images ===
        $image_fields = ['featured_image_one', 'featured_image_two'];

        foreach ($image_fields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {

                    $uploadData = $this->upload->data();
                    $serviceData[$field] = 'uploads/membership-eligibility/' . $uploadData['file_name'];

                    if (!empty($current->$field) && file_exists(FCPATH . $current->$field)) {
                        unlink(FCPATH . $current->$field);
                    }

                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        // === UPDATE PDF ===
        if (!empty($_FILES['pdf']['name'])) {

            $pdfConfig = [
                'upload_path' => $uploadPath,
                'allowed_types' => 'pdf',
                'max_size' => 10000,
                'encrypt_name' => TRUE,
            ];

            $this->upload->initialize($pdfConfig);

            if ($this->upload->do_upload('pdf')) {

                $pdfData = $this->upload->data();
                $serviceData['pdf'] = 'uploads/membership-eligibility/' . $pdfData['file_name'];

                // delete old pdf
                if (!empty($current->pdf) && file_exists(FCPATH . $current->pdf)) {
                    unlink(FCPATH . $current->pdf);
                }

            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['pdf' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // === Update Record ===
        $updated = $this->membership_eligibility_model->update_membership_eligibility($id, $serviceData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Membership Eligibility Details updated successfully!');
            echo json_encode(['status' => 'success', 'redirect' => base_url('membership-eligibility-list')]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update details. Try again.']
            ]);
        }
    }

    public function delete_membership_eligibility($id)
    {
        $this->load->model('membership_eligibility_model');
        $this->membership_eligibility_model->delete_membership_eligibility($id);
        $this->session->set_flashdata('message', 'Membership Eligibility details delete successfully');
        redirect(base_url('membership-eligibility-list'));

    }

}