<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Section extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('Section_model');
    }

    // Ajax se status check karne ke liye
    public function check_status()
    {
        // Temporary: Ajax check comment kar do
        // if ($this->input->is_ajax_request()) {

        $section_name = $this->input->post('section_name');

        if (empty($section_name)) {
            echo json_encode([
                'success' => false,
                'message' => 'Invalid section name'
            ]);
            return;
        }

        // Database se section name se status check karein
        $section = $this->Section_model->get_section_by_name($section_name);

        if ($section && count($section) > 0) {
            // Enum values: 'active' ya 'inactive'
            $status_text = $section[0]->status; // 'active' or 'inactive'

            echo json_encode([
                'success' => true,
                'status' => $status_text, // 'active' or 'inactive'
                'message' => 'Status fetched successfully'
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Section not found'
            ]);
        }

        // } else {
        //     show_404();
        // }
    }

    public function update_status()
    {
        $section_name = $this->input->post('section_name');
        $new_status = $this->input->post('status');

        if (empty($section_name) || empty($new_status)) {
            echo json_encode([
                'success' => false,
                'message' => 'Invalid data'
            ]);
            return;
        }

        // Validate status value
        if (!in_array($new_status, ['active', 'inactive'])) {
            echo json_encode([
                'success' => false,
                'message' => 'Invalid status value'
            ]);
            return;
        }

        // Database me status update karein
        $update = $this->Section_model->update_status_by_name($section_name, $new_status);

        if ($update) {
            echo json_encode([
                'success' => true,
                'message' => 'Status updated successfully',
                'new_status' => $new_status
            ]);
        } else {
            echo json_encode([
                'success' => false,
                'message' => 'Failed to update status'
            ]);
        }
    }
}
?>