<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Service extends CI_Controller
{
    public function index()
    {
        $this->load->model('Service_model');
        $data['service'] = $this->Service_model->get_all_service();
        $this->load->view('admin/service', $data);
    }
    public function add_service()
    {
        $this->load->view('admin/add-service');
    }

    public function submit_service()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('service', 'Service', 'required|trim');
        $this->form_validation->set_rules(
            'slug',
            'Slug',
            'required|trim|regex_match[/^[a-z0-9-]+$/]',
            array(
                'regex_match' => 'The %s may only contain lowercase letters, numbers, and hyphens.'
            )
        );
        $this->form_validation->set_rules('hindi_service', 'Hindi Service', 'required|trim');
        $this->form_validation->set_rules(
            'hindi_slug',
            'Hindi Slug',
            'required|trim|regex_match[/^[\x{0900}-\x{097F}\s-]+$/u]',
            array(
                'regex_match' => 'The %s may only contain Hindi letters, spaces, and hyphens.'
            )
        );

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'service' => form_error('service'),
                'slug' => form_error('slug'),
                'hindi_service' => form_error('hindi_service'),
                'hindi_slug' => form_error('hindi_slug'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $serviceCategory = [
            'service' => $this->input->post('service'),
            'slug' => $this->input->post('slug'),
            'hindi_service' => $this->input->post('hindi_service'),
            'hindi_slug' => $this->input->post('hindi_slug'),
        ];

        $this->load->model('service_model');
        $insert_id = $this->service_model->add_service($serviceCategory);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Service added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('service-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save service, try again.']
            ]);
        }
    }

    public function edit_service($id)
    {
        $this->load->model('service_model');
        $data['data'] = $this->service_model->get_service_by_id($id);
        $this->load->view('admin/edit-service', $data);
    }

    public function update_service()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('service', 'Service', 'required|trim');
        $this->form_validation->set_rules(
            'slug',
            'Slug',
            'required|trim|regex_match[/^[a-z0-9-]+$/]',
            array(
                'regex_match' => 'The %s may only contain lowercase letters, numbers, and hyphens.'
            )
        );
        $this->form_validation->set_rules('hindi_service', 'Hindi Service', 'required|trim');
        $this->form_validation->set_rules(
            'hindi_slug',
            'Hindi Slug',
            'required|trim|regex_match[/^[\x{0900}-\x{097F}\s-]+$/u]',
            array(
                'regex_match' => 'The %s may only contain Hindi letters, spaces, and hyphens.'
            )
        );

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'service' => form_error('service'),
                'slug' => form_error('slug'),
                'hindi_service' => form_error('hindi_service'),
                'hindi_slug' => form_error('hindi_slug'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get service ID
        $id = $this->input->post('id');

        // ✅ Correct: Save input values, not form_error()
        $serviceData = [
            'service' => $this->input->post('service', true),
            'slug' => $this->input->post('slug', true),
            'hindi_service' => $this->input->post('hindi_service', true),
            'hindi_slug' => $this->input->post('hindi_slug', true),
        ];

        // Load model
        $this->load->model('service_model');

        // Update service
        $updated = $this->service_model->update_service($id, $serviceData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Service updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('service-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Service, please try again.']
            ]);
        }
    }


    public function delete_service($id)
    {
        $this->load->model('service_model');
        $this->service_model->delete_service($id);
        $this->session->set_flashdata('message', 'Service delete successfully');
        redirect(base_url('service-list'));

    }

    public function service_details()
    {
        $this->load->model('service_model');
        $data['details'] = $this->service_model->get_all_service_details();
        $this->load->view('admin/service-details', $data);
    }

    public function add_service_details()
    {
        $this->load->model('service_model');
        $data['service'] = $this->service_model->get_all_service();
        $this->load->view('admin/add-service-details', $data);
    }

    public function submit_service_details()
    {
        $this->form_validation->set_error_delimiters('', '');

        // === Validation rules ===
        $this->form_validation->set_rules('service_name', 'Service Name', 'required|trim');
        $this->form_validation->set_rules('hindi_service_name', 'Hindi Service Name', 'required|trim');
        $this->form_validation->set_rules('title_one', 'Title One', 'required|trim');
        $this->form_validation->set_rules('hindi_title_one', 'Hindi Title One', 'required|trim');
        $this->form_validation->set_rules('content_one', 'Content One', 'required|trim');
        $this->form_validation->set_rules('hindi_content_one', 'Hindi Content One', 'required|trim');
        $this->form_validation->set_rules('title_two', 'Title Two', 'required|trim');
        $this->form_validation->set_rules('hindi_title_two', 'Hindi Title Two', 'required|trim');
        $this->form_validation->set_rules('content_two', 'Content Two', 'required|trim');
        $this->form_validation->set_rules('hindi_content_two', 'Hindi Content Two', 'required|trim');
        $this->form_validation->set_rules('title_three', 'Title Three', 'required|trim');
        $this->form_validation->set_rules('hindi_title_three', 'Hindi Title Three', 'required|trim');
        $this->form_validation->set_rules('content_three', 'Content Three', 'required|trim');
        $this->form_validation->set_rules('hindi_content_three', 'Hindi Content Three', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'service_name' => form_error('service_name'),
                'hindi_service_name' => form_error('hindi_service_name'),
                'title_one' => form_error('title_one'),
                'hindi_title_one' => form_error('hindi_title_one'),
                'content_one' => form_error('content_one'),
                'hindi_content_one' => form_error('hindi_content_one'),
                'title_two' => form_error('title_two'),
                'hindi_title_two' => form_error('hindi_title_two'),
                'content_two' => form_error('content_two'),
                'hindi_content_two' => form_error('hindi_content_two'),
                'title_three' => form_error('title_three'),
                'hindi_title_three' => form_error('hindi_title_three'),
                'content_three' => form_error('content_three'),
                'hindi_content_three' => form_error('hindi_content_three'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data ===
        $serviceData = [
            'service_name' => $this->input->post('service_name'),
            'hindi_service_name' => $this->input->post('hindi_service_name'),
            'title_one' => $this->input->post('title_one'),
            'hindi_title_one' => $this->input->post('hindi_title_one'),
            'content_one' => $this->input->post('content_one'),
            'hindi_content_one' => $this->input->post('hindi_content_one'),
            'title_two' => $this->input->post('title_two'),
            'hindi_title_two' => $this->input->post('hindi_title_two'),
            'content_two' => $this->input->post('content_two'),
            'hindi_content_two' => $this->input->post('hindi_content_two'),
            'title_three' => $this->input->post('title_three'),
            'hindi_title_three' => $this->input->post('hindi_title_three'),
            'content_three' => $this->input->post('content_three'),
            'hindi_content_three' => $this->input->post('hindi_content_three'),
            'created_at' => date('Y-m-d H:i:s'),
        ];

        // === File Upload Config ===
        $uploadPath = './uploads/services/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120, // 5MB
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Handle Image Uploads ===
        $imageFields = [
            'featured_image_one',
            'featured_image_two',
            'featured_image_three',
        ];

        foreach ($imageFields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $uploadData = $this->upload->data();
                    $serviceData[$field] = 'uploads/services/' . $uploadData['file_name'];
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => [$field => 'Please select an image for ' . str_replace('_', ' ', $field)]
                ]);
                return;
            }
        }

        // === Save service ===
        $this->load->model('service_model');
        $service_id = $this->service_model->add_service_details($serviceData);

        if ($service_id) {
            $this->session->set_flashdata('message', 'Service Details added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('service-details-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save service, please try again.']
            ]);
        }
    }

    public function edit_service_details($id)
    {
        $this->load->model('service_model');
        $data['details'] = $this->service_model->get_service_details_by_id($id);
        $data['service'] = $this->service_model->get_all_service();
        $this->load->view('admin/edit-service-details', $data);
    }

    public function update_service_details()
    {
        $this->form_validation->set_error_delimiters('', '');

        // === Validation Rules ===
        $this->form_validation->set_rules('service_name', 'service Name', 'required|trim');
        $this->form_validation->set_rules('hindi_service_name', 'service Name', 'required|trim');
        $this->form_validation->set_rules('title_one', 'Title One', 'required|trim');
        $this->form_validation->set_rules('hindi_title_one', 'Hindi Title One', 'required|trim');
        $this->form_validation->set_rules('content_one', 'Content One', 'required|trim');
        $this->form_validation->set_rules('hindi_content_one', 'Hindi Content One', 'required|trim');
        $this->form_validation->set_rules('title_two', 'Title Two', 'required|trim');
        $this->form_validation->set_rules('hindi_title_two', 'Hindi Title Two', 'required|trim');
        $this->form_validation->set_rules('content_two', 'Content Two', 'required|trim');
        $this->form_validation->set_rules('hindi_content_two', 'Hindi Content Two', 'required|trim');
        $this->form_validation->set_rules('title_three', 'Title Three', 'required|trim');
        $this->form_validation->set_rules('hindi_title_three', 'Hindi Title Three', 'required|trim');
        $this->form_validation->set_rules('content_three', 'Content Three', 'required|trim');
        $this->form_validation->set_rules('hindi_content_three', 'Hindi Content Three', 'required|trim');
        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'service_name' => form_error('service_name'),
                'hindi_service_name' => form_error('hindi_service_name'),
                'title_one' => form_error('title_one'),
                'hindi_title_one' => form_error('hindi_title_one'),
                'content_one' => form_error('content_one'),
                'hindi_content_one' => form_error('hindi_content_one'),
                'title_two' => form_error('title_two'),
                'hindi_title_two' => form_error('hindi_title_two'),
                'content_two' => form_error('content_two'),
                'hindi_content_two' => form_error('hindi_content_two'),
                'title_three' => form_error('title_three'),
                'hindi_title_three' => form_error('hindi_title_three'),
                'content_three' => form_error('content_three'),
                'hindi_content_three' => form_error('hindi_content_three'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // === Prepare Data ===
        $id = $this->input->post('id');
        $serviceData = [
            'service_name' => $this->input->post('service_name'),
            'hindi_service_name' => $this->input->post('hindi_service_name'),
            'title_one' => $this->input->post('title_one'),
            'hindi_title_one' => $this->input->post('hindi_title_one'),
            'content_one' => $this->input->post('content_one'),
            'hindi_content_one' => $this->input->post('hindi_content_one'),
            'title_two' => $this->input->post('title_two'),
            'hindi_title_two' => $this->input->post('hindi_title_two'),
            'content_two' => $this->input->post('content_two'),
            'hindi_content_two' => $this->input->post('hindi_content_two'),
            'title_three' => $this->input->post('title_three'),
            'hindi_title_three' => $this->input->post('hindi_title_three'),
            'content_three' => $this->input->post('content_three'),
            'hindi_content_three' => $this->input->post('hindi_content_three'),
            'created_at' => date('Y-m-d H:i:s'),
        ];

        // === Upload Configuration ===
        $uploadPath = './uploads/services/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config = [
            'upload_path' => $uploadPath,
            'allowed_types' => 'jpg|jpeg|png|webp|gif|svg',
            'max_size' => 5120,
            'encrypt_name' => TRUE,
        ];

        $this->load->library('upload', $config);

        // === Helper to Handle Uploads ===
        $image_fields = ['featured_image_one', 'featured_image_two', 'featured_image_three'];

        // Fetch current record to delete old images
        $this->load->model('service_model');
        $current = $this->service_model->get_service_details($id);

        foreach ($image_fields as $field) {
            if (!empty($_FILES[$field]['name'])) {
                if ($this->upload->do_upload($field)) {
                    $uploadData = $this->upload->data();
                    $serviceData[$field] = 'uploads/services/' . $uploadData['file_name'];

                    // Delete old image if exists
                    if (!empty($current->$field) && file_exists(FCPATH . $current->$field)) {
                        unlink(FCPATH . $current->$field);
                    }
                } else {
                    echo json_encode([
                        'status' => 'error',
                        'errors' => [$field => $this->upload->display_errors('', '')]
                    ]);
                    return;
                }
            }
        }

        // === Update Database ===
        $updated = $this->service_model->update_service_details($id, $serviceData);

        if ($updated) {
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('service-details-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update service details. Please try again.']
            ]);
        }
    }
    public function delete_service_details($id)
    {
        $this->load->model('service_model');
        $this->service_model->delete_service_details($id);
        $this->session->set_flashdata('message', 'service details delete successfully');
        redirect(base_url('service-details-list'));

    }
}