<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Teams extends CI_Controller
{
    public function index()
    {
        $this->load->model('Team_model');
        $data['team'] = $this->Team_model->get_all();
        $this->load->view('admin/teams', $data);
    }
    public function add_team()
    {
        $this->load->view('admin/add-team');
    }

   public function submit_team()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('hindi_name', 'Name', 'required|trim');
        $this->form_validation->set_rules('email', 'Email', 'trim');
        $this->form_validation->set_rules('phone', 'Phone', 'trim');
        $this->form_validation->set_rules('designation', 'Designation', 'required|trim');
        $this->form_validation->set_rules('hindi_designation', 'Hindi Designation', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'name' => form_error('name'),
                'hindi_name' => form_error('hindi_name'),
                'designation' => form_error('designation'),
                'hindi_designation' => form_error('hindi_designation'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $teamData = [
            'category' => $this->input->post('category'),
            'name' => $this->input->post('name'),
            'hindi_name' => $this->input->post('hindi_name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'designation' => $this->input->post('designation'),
            'hindi_designation' => $this->input->post('hindi_designation'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/team/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $teamData['featured_image'] = 'uploads/team/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_image' => 'Please select an image']
            ]);
            return;
        }

        // Save blog
        $this->load->model('team_model');
        $team_id = $this->team_model->add_team($teamData);

        if ($team_id) {
            $this->session->set_flashdata('message', 'Team Member added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('teams-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Team Member, try again.']
            ]);
        }
    }

    public function edit_team($id)
    {
        $this->load->model('team_model');
        $data['team'] = $this->team_model->get_team_by_id($id);
        $this->load->view('admin/edit-team', $data);
    }


    public function update_team()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('category', 'Category', 'required|trim');
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('hindi_name', 'Name', 'required|trim');
        $this->form_validation->set_rules('email', 'Email', 'trim');
        $this->form_validation->set_rules('phone', 'Phone', 'trim');
        $this->form_validation->set_rules('designation', 'Designation', 'required|trim');
        $this->form_validation->set_rules('hindi_designation', 'Hindi Designation', 'required|trim');
        $this->form_validation->set_rules('content', 'Content', 'trim');
        $this->form_validation->set_rules('hindi_content', 'Hindi Content', 'trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'category' => form_error('category'),
                'name' => form_error('name'),
                'hindi_name' => form_error('hindi_name'),
                'designation' => form_error('designation'),
                'hindi_designation' => form_error('hindi_designation'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $teamData = [
            'category' => $this->input->post('category'),
            'name' => $this->input->post('name'),
            'hindi_name' => $this->input->post('hindi_name'),
            'email' => $this->input->post('email'),
            'phone' => $this->input->post('phone'),
            'designation' => $this->input->post('designation'),
            'hindi_designation' => $this->input->post('hindi_designation'),
            'content' => $this->input->post('content'),
            'hindi_content' => $this->input->post('hindi_content'),
        ];

        // Upload folder config
        $uploadPath = './uploads/team/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // Load model
        $this->load->model('team_model');

        // Get old image to delete if replaced
        $oldTeam = $this->team_model->get_team_by_id($id);
        $oldImage = $oldTeam ? $oldTeam->featured_image : '';

        // ✅ If new image uploaded, replace old one
        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $teamData['featured_image'] = 'uploads/team/' . $uploadData['file_name'];

                // Delete old image (if exists)
                if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                    unlink('./' . $oldImage);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // ✅ Update blog
        $updated = $this->team_model->update_team($id, $teamData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Team Member updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('teams-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Team Member, please try again.']
            ]);
        }
    }

    public function delete_team($id)
    {
        $this->load->model('team_model');
        $this->team_model->delete_team($id);
        $this->session->set_flashdata('message', 'Team Member delete successfully');
        redirect(base_url('teams-list'));

    }

}