<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Testimonials extends CI_Controller
{
    public function index()
    {
        $this->load->model('Testimonial_model');
        $data['testimonials'] = $this->Testimonial_model->get_all();
        $this->load->view('admin/testimonials', $data);
    }
    public function add_testimonials()
    {
        $this->load->view('admin/add-testimonials');
    }

    public function submit_testimonials()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('hindi_name', 'Hindi Name', 'required|trim');
        $this->form_validation->set_rules('comment', 'Comment', 'required|trim');
        $this->form_validation->set_rules('hindi_comment', 'Hindi Comment', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'name' => form_error('name'),
                'hindi_name' => form_error('hindi_name'),
                'comment' => form_error('comment'),
                'hindi_comment' => form_error('hindi_comment'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $testimonialsData = [
            'name' => $this->input->post('name'),
            'hindi_name' => $this->input->post('hindi_name'),
            'comment' => $this->input->post('comment'),
            'hindi_comment' => $this->input->post('hindi_comment'),
        ];

        // Upload folder config
        $uploadPath = './uploads/testimonials/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $testimonialsData['featured_image'] = 'uploads/testimonials/' . $uploadData['file_name'];
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['featured_image' => 'Please select an image']
            ]);
            return;
        }

        // Save blog
        $this->load->model('Testimonial_model');
        $testimonial_id = $this->Testimonial_model->add_testimonials($testimonialsData);

        if ($testimonial_id) {
            $this->session->set_flashdata('message', 'Testimonial added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('testimonials-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save Testimonial, try again.']
            ]);
        }
    }

    public function edit_testimonials($id)
    {
        $this->load->model('Testimonial_model');
        $data['data'] = $this->Testimonial_model->get_testimonials_by_id($id);
        $this->load->view('admin/edit-testimonials', $data);
    }

    public function update_testimonial()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('name', 'Name', 'required|trim');
        $this->form_validation->set_rules('hindi_name', 'Name', 'required|trim');
        $this->form_validation->set_rules('comment', 'Comment', 'required|trim');
        $this->form_validation->set_rules('hindi_comment', 'Comment', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'name' => form_error('name'),
                'hindi_name' => form_error('hindi_name'),
                'comment' => form_error('comment'),
                'hindi_comment' => form_error('hindi_comment'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        // Get blog ID
        $id = $this->input->post('id');

        // Prepare updated data
        $testimonialsData = [
            'name' => $this->input->post('name'),
            'hindi_name' => $this->input->post('hindi_name'),
            'comment' => $this->input->post('comment'),
            'hindi_comment' => $this->input->post('hindi_comment'),
        ];

        // Upload folder config
        $uploadPath = './uploads/testimonials/';
        if (!is_dir($uploadPath)) {
            mkdir($uploadPath, 0777, true);
        }

        $config['upload_path'] = $uploadPath;
        $config['allowed_types'] = 'jpg|jpeg|png|webp|gif|svg';
        $config['max_size'] = 5120; // 5MB
        $config['encrypt_name'] = TRUE;

        $this->load->library('upload', $config);

        // Load model
        $this->load->model('Testimonial_model');

        // Get old image to delete if replaced
        $oldTestimonials = $this->Testimonial_model->get_testimonials_by_id($id);
        $oldImage = $oldTestimonials ? $oldTestimonials->featured_image : '';

        // ✅ If new image uploaded, replace old one
        if (!empty($_FILES['featured_image']['name'])) {
            if ($this->upload->do_upload('featured_image')) {
                $uploadData = $this->upload->data();
                $testimonialsData['featured_image'] = 'uploads/testimonials/' . $uploadData['file_name'];

                // Delete old image (if exists)
                if (!empty($oldImage) && file_exists('./' . $oldImage)) {
                    unlink('./' . $oldImage);
                }
            } else {
                echo json_encode([
                    'status' => 'error',
                    'errors' => ['featured_image' => $this->upload->display_errors('', '')]
                ]);
                return;
            }
        }

        // ✅ Update blog
        $updated = $this->Testimonial_model->update_testimonials($id, $testimonialsData);

        if ($updated) {
            $this->session->set_flashdata('message', 'Testimonials updated successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('testimonials-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to update Testimonials, please try again.']
            ]);
        }
    }

    public function delete_testimonials($id)
    {
        $this->load->model('Testimonial_model');
        $this->Testimonial_model->delete_testimonials($id);
        $this->session->set_flashdata('message', 'Testimonials delete successfully');
        redirect(base_url('testimonials-list'));

    }
}