<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Video_gallery extends CI_Controller
{
    public function index()
    {
        $this->load->model('video_gallery_model');
        $data['videos'] = $this->video_gallery_model->get_all();
        $this->load->view('admin/video-gallery', $data);
    }

    public function add_video_gallery()
    {
        $this->load->view('admin/add-video-gallery');
    }

    public function submit_video_gallery()
    {
        $this->form_validation->set_error_delimiters('', '');

        // Validation rules
        $this->form_validation->set_rules('video_link', 'Video Link', 'required|trim');

        if ($this->form_validation->run() == FALSE) {
            $errors = [
                'video_link' => form_error('video_link'),
            ];
            echo json_encode(['status' => 'error', 'errors' => $errors]);
            return;
        }

        $videoGallery = [
            'video_link' => $this->input->post('video_link'),
        ];

        $this->load->model('video_gallery_model');
        $insert_id = $this->video_gallery_model->add_video_gallery($videoGallery);

        if ($insert_id) {
            $this->session->set_flashdata('message', 'Add video gallery added successfully!');
            echo json_encode([
                'status' => 'success',
                'redirect' => base_url('video-gallery-list')
            ]);
        } else {
            echo json_encode([
                'status' => 'error',
                'errors' => ['db' => 'Failed to save service, try again.']
            ]);
        }
    }

    public function set_status($id)
    {
        $this->load->model('video_gallery_model');
        $new_status = $this->video_gallery_model->set_status($id);

        if ($new_status) {
            $this->session->set_flashdata('message', "Slider $new_status successfully");
        } else {
            $this->session->set_flashdata('message', "Slider not found");
        }

        redirect(base_url('video-gallery-list'));
    }

    public function delete_video_gallery($id)
    {
        $this->load->model('video_gallery_model');
        $this->video_gallery_model->delete_video($id);
        $this->session->set_flashdata('message', 'Gallery video delete successfully');
        redirect(base_url('video-gallery-list'));

    }
}